


stats::binomialPF:=proc(n, p)
local fp, fn;
option escape;
begin
  if args(0)<>2 then
     error("expecting two arguments")
  end_if:

  // ------------- check p -------------
  fp:= float(p):
  if domtype(fp) = DOM_FLOAT then
     if fp < 0 or fp > 1 then
        error("the 'probability parameter' p must satisfy 0 <= p <= 1"):
     end_if;
  end_if;
  if domtype(fp) = DOM_COMPLEX then
     error("the 'probability parameter' must be real"):
  end_if;

  // ------------- check n -------------
  fn:= float(n):
  if domtype(n) = DOM_INT and n < 1 then
     error("the 'trial parameter' must be symbolic or an integer >= 1"):
  end_if;
  if domtype(fn) = DOM_FLOAT and domtype(n) <> DOM_INT then
     error("the 'trial parameter' must be symbolic or an integer >= 1"):
  end_if;
  if domtype(fn) = DOM_COMPLEX then
     error("the 'trial parameter' must be real"):
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc(x)
  local fx, nn, pp, fp, qq;
  begin
    if args(0)<>1 then
       error("expecting one argument")
    end_if:

    // double check the parameters n and p. They
    // might have changed since this procedure was
    // created:

    // ------------- check p -------------
    pp:= context(p):
    fp:= float(pp):
    if domtype(fp) = DOM_FLOAT then
       if fp < 0 or fp > 1 then
          error("the 'probability parameter' p must satisfy 0 <= p <= 1"):
       end_if;
    end_if;
    if domtype(fp) = DOM_COMPLEX then
       error("the 'probability parameter' must be real"):
    end_if;

    // ------------- check n -------------
    nn:= context(n):
    if domtype(nn) = DOM_INT and nn < 1 then
       error("the 'trial parameter' must be symbolic or an integer >= 1"):
    end_if;
    if domtype(float(nn)) = DOM_FLOAT and domtype(nn) <> DOM_INT then
       error("the 'trial parameter' must be symbolic or an integer >= 1"):
    end_if;
    if domtype(float(nn)) = DOM_COMPLEX then
       error("the trial parameter must be real"):
    end_if;

    // now we can assume that n is an integer

    if x = -infinity then return(0); end_if;
    if x =  infinity then return(0); end_if;

    // P(X = x) = binomial(n, x)*p^x*q^(n-x)
    // if x is an integer with 0 <= x <= n
    // We assume n >= 1.
    // If x = 0, then P(X = x) = q^n
    // If x = 1, then P(X = x) = n*p*q^(n-1)
    // If 1< x, then we do not know whether x <= n
    // unless // n is numerical.
    // Hence return an explicit result for x = 0, 1, n, n-1 
    // for any n:

    // -------------- check x = 0, 1, ---------------
    fx:= float(x):
    if domtype(fx) = DOM_COMPLEX then
       error("the argument must be real"):
    end_if;

    if domtype(fx) = DOM_FLOAT then
       // if x <> DOM_INT and x <> float(DOM_INT), then return 0
       if not iszero(frac(x)) then
          if domtype(x) = DOM_FLOAT then
               return(float(0))
          else return(0)
          end_if;
       end_if;
       if iszero(x) then
          if domtype(x) = DOM_FLOAT then
               qq:= float(1 - pp):
               return(qq^nn);
          else return((1 - pp)^nn);
          end_if;
       end_if;
       if iszero(x - 1) then
          if domtype(x) = DOM_FLOAT then
               qq:= float(1 - pp):
               pp:= float(pp):
               return(float(nn*qq^(nn-1)*pp));
          else return(nn*(1 - pp)^(nn-1)*pp);
          end_if;
       end_if;
    end_if;
    // -------------- check x = n, n - 1, ---------------
    if iszero(n - x) then
       if domtype(x) = DOM_FLOAT then
            return(fp^nn);
       else return(pp^nn);
       end_if;
    end_if;
    if iszero(n - 1 - x) then
       if domtype(x) = DOM_FLOAT then
            qq:= float(1 - pp):
            pp:= float(pp):
            return(float(nn*fp^(nn-1)*qq));
       else return(nn*pp^(nn-1)*(1 - pp));
       end_if;
    end_if;

    // ------------- double check n -------------
    if domtype(nn) <> DOM_INT then
       // n is not an integer
       return(hold(stats::binomialPF)(nn, pp)(x));
    end_if;

    // -------------- check x >= n --------------
    if domtype(fx) = DOM_FLOAT and fx > nn then
       if domtype(x) = DOM_FLOAT then
            return(float(0))
       else return(0)
       end_if;
    end_if;

   // ------------- check x -------------
    if domtype(fx) <> DOM_FLOAT then
       // x is symbolic, nothing can be done
       return(hold(stats::binomialPF)(nn, pp)(x));
    end_if;

    //---------------------------------------------
    // now we are sure that x is numerical
    //---------------------------------------------

    if fx < 0 then
       if domtype(x) = DOM_FLOAT then
             return(float(0))
       else return(0)
       end_if;
    end_if;

    //----------------------------------------------
    // now we are sure that x is numerical and x > 0
    //----------------------------------------------

    // produce a floating point result?
    // If so, convert pp and qq to floats for speed
    if domtype(x) = DOM_FLOAT then
         qq:= float(1 - pp):
         pp:= fp;
    else qq:= 1 - pp;
    end_if:

    //---------------------------------------------
    // now we are sure that n is an integer >= 1
    //---------------------------------------------

    //---------------------------------------
    // Here, we can assume
    // --  n is an integer >= 1
    // --  x can be converted to a float
    // --  p can be symbolic or numeric
    // ---------------------------------------

    if domtype(x) = DOM_FLOAT then
         return(binomial(float(nn), fx)*pp^fx*qq^(float(nn-x)))
    else return(binomial(nn, x)*pp^x*qq^(nn-x));
    end_if:
  end_proc:
end_proc:
