
stats::empiricalPF:=proc(data)
local sorted;
option escape;
begin
  if args(0) < 1 then
     error("expecting at least one argument")
  end_if:

  //----------------------------------------------------
  // stats::getdata accepts "all_data" and "numeric_only".
  // Use "all_data", because with "numeric_only" exact numerical
  // expressions such as sqrt(2), PI etc. would be converted to
  // floats.
  //----------------------------------------------------
  data:= stats::getdata(testargs(), "all_data", 1, args(1..args(0))):
  if domtype(data) = DOM_STRING then
       error(data)
  end_if:
  sorted:= FALSE: // on input, the data may not be sorted.
                  // Sorting will only be necessary for
                  // symbolic return values (consistency with
                  // empiricalCDF)
  if testargs() then
     if data = [] then
        error("empty sample"):
     end_if:
     if map({op(data)}, domtype@float) <> {DOM_FLOAT} then
        error("some data could not be converted to floats")
     end_if:
  end_if:
  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc(x)
  local n, xx, getProb;
  begin
    if args(0)<>1 then
       error("expecting one argument")
    end_if:
    n:= nops(data);

    getProb:= proc(x)
    begin
      // symbolic return if x or some of the data are not numeric
      if domtype(float(x)) <> DOM_FLOAT then
           if not sorted then
                 data:= sort(data, (x, y) -> float(x) < float(y)):
                 sorted:= TRUE;
           end_if;
           return(hold(stats::empiricalPF)(data)(x));
      end_if;
      return(nops(select(data, _equal, x))/n);
    end_proc;

    if type(x) = DOM_LIST then
       x:= {op(x)}; // remove duplicates
    end_if;
    if type(x) = DOM_SET then
         return(_plus(getProb(xx) $ xx in x));
    else return(getProb(x));
    end_if;
  end_proc;
end_proc:
