/*
Call:          stats::chisquareQuantile(m)

Parameter(s):  m - the mean: an arithmetical expression
                   representing a positive real value

Returns: a procedure
------------------------------------*/

stats::chisquareQuantile:=proc(m)
local fm;
option escape;
begin
  if args(0) <> 1 then
     error("expecting one argument")
  end_if:

  // ------------- check m -------------
  fm:= float(m):
  if domtype(fm) = DOM_FLOAT and fm <= 0 then
     error("the mean must be positive"):
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc(x)
  local mm, fm, fx;
  begin
    if args(0) <> 1 then
       error("expecting one argument")
    end_if:

    // ------------- check m -------------
    mm:= context(m):
    fm:= float(mm):
    if domtype(fm) = DOM_FLOAT and fm <= 0 then
       error("the mean must be positive"):
    end_if;
    if domtype(fm) = DOM_COMPLEX then
       error("the mean must be real");
    end_if;

    // ----------- check x ----------
    fx:= float(x):
    if domtype(fx) = DOM_COMPLEX then
       error("expecting a real argument");
    end_if;
    if domtype(fx) <> DOM_FLOAT then
       // x is symbolic, nothing can be done
       return(hold(stats::chisquareQuantile)(mm)(x));
    end_if;

    //------------------------------------
    // now we are sure that x is numerical
    //------------------------------------

    if fx > 1 then
       error("expecting an argument 0 <= x <= 1"):
    end_if;
    if iszero(1 - x) then
       return(infinity);
    end_if;
    if iszero(x) then
       // return a float, even for exact x!
       return(float(0));
    end_if;
    if fx < 0 then
       error("expecting an argument 0 <= x <= 1"):
    end_if;

    //---------------------------------------------
    // now we are sure that x is numerical and 0 < x < 1
    //---------------------------------------------

    // --------- float evaluation ? ------------
    if domtype(fm) <> DOM_FLOAT then
      // m is symbolic, nothing can be done
      return(hold(stats::chisquareQuantile)(mm)(x));
    end_if:

    stats::gammaQuantile(mm/2, 2)(x);
  end_proc:
end_proc:
