/*
Walter Oevel, 23.7.01
  - ueberarbeitet, sollte ok sein
  - Todo: - a bit more internal documentation (comments
            in the header) would be nice
          - Apart from this: OK
*/

stats::erlangQuantile:= proc(a, b)
local fa, fb;
option escape;
begin
  if args(0)<>2 then
    error("expecting two aruments") 
  end_if:

  // ------------- check a -------------
  fa:= float(a):
  if domtype(fa) = DOM_FLOAT and fa <= 0 then
     error("the shape parameter must be positive"):
  end_if;
  if domtype(fa) = DOM_COMPLEX then
     error("the shape parameter must be real");
  end_if;

  // ------------- check b -------------
  fb:= float(b):
  if domtype(fb) = DOM_FLOAT and fb <= 0 then
     error("the scale parameter must be positive"):
  end_if;
  if domtype(fb) = DOM_COMPLEX then
     error("the scale parameter must be real");
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc(x)
  local aa, bb, fa, fb, fx;
  begin
     if args(0) <> 1 then
         error("one argument expected")
     end_if:

     // ------------- check a -------------
     aa:= context(a):
     fa:= float(aa):
     if domtype(fa) = DOM_FLOAT and fa <= 0 then
        error("the shape parameter must be positive"):
     end_if;
     if domtype(fa) = DOM_COMPLEX then
        error("the shape parameter must be real");
     end_if;

     // ------------- check b -------------
     bb:= context(b):
     fb:= float(bb):
     if domtype(fb) = DOM_FLOAT and fb <= 0 then
        error("the scale parameter must be positive"):
     end_if;
     if domtype(fb) = DOM_COMPLEX then
        error("the scale parameter must be real");
     end_if;

     // ------------- check x -------------
     fx:= float(x);
     if domtype(fx) = DOM_COMPLEX then
        error("expecting a real argument");
     end_if;
     if domtype(fx) <> DOM_FLOAT then
        // x is symbolic, nothing can be done
        return(hold(stats::erlangQuantile)(aa, bb)(x));
     end_if;

    //------------------------------------
    // now we are sure that x is numerical
    //------------------------------------

    if fx > 1 then
       error("expecting an argument 0 <= x <= 1"):
    end_if;
    if iszero(1 - x) then
       return(infinity);
    end_if;
    if iszero(x) then
       // return a float, even for exact x!
       return(float(0));
    end_if;
    if fx < 0 then
       error("expecting an argument 0 <= x <= 1"):
    end_if;

    //---------------------------------------------
    // now we are sure that x is numerical and 0 < x < 1
    //---------------------------------------------

    // --------- float evaluation ? ------------
    if domtype(fa) <> DOM_FLOAT or
       domtype(fb) <> DOM_FLOAT then
      // at least one of the parameters is symbolic, nothing can be done
      return(hold(stats::erlangQuantile)(aa, bb)(x));
    end_if:

    // Everything is numerical and a float can be computed.
    // The numerical solver is implemented in gammaQuantile:
    stats::gammaQuantile(aa, 1/bb)(x);
 end_proc:
end_proc:
