/*-----------------------------------------------------------
Walter Oevel, 24.8.01
  - ueberarbeitet, sollte ok sein
  - Todo: - a bit more internal documentation (comments
            in the header) would be nice
          - Apart from this: OK
-----------------------------------------------------------*/

stats::fQuantile:=proc(a, b)
local fa, fb;
option escape;
begin
  if args(0) <> 2 then
     error("expecting two parameters")
  end_if:
  // ------------- check a -------------
  fa:= float(a):
  if domtype(fa) = DOM_FLOAT and fa <= 0 then
     error("the first shape parameter must be positive"):
  end_if;
  if domtype(fa) = DOM_COMPLEX then
     error("the first shape parameter must be real");
  end_if;

  // ------------- check b -------------
  fb:= float(b):
  if domtype(fb) = DOM_FLOAT and fb <= 0 then
     error("the second shape parameter must be positive"):
  end_if;
  if domtype(fb) = DOM_COMPLEX then
     error("the second shape parameter must be real");
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc(x)
  local aa, bb, fa, fb, fx, fw, z, zz, boost;
  save DIGITS;
  begin 
    if args(0)<>1 then
        error("one argument expected")
    end_if:

    // ------------- check a -------------
     aa:= context(a):
     fa:= float(aa):
     if domtype(fa) = DOM_FLOAT and fa <= 0 then
        error("the first shape parameter must be positive"):
     end_if;
     if domtype(fa) = DOM_COMPLEX then
        error("the first shape parameter must be real");
     end_if;
     // ------------- check b -------------
     bb:= context(b):
     fb:= float(bb):
     if domtype(fb) = DOM_FLOAT and fb <= 0 then
        error("the second shape parameter must be positive"):
     end_if;
     if domtype(fb) = DOM_COMPLEX then
        error("the second shape parameter must be real");
     end_if;

     // ------------- check x -------------
     fx:= float(x);
     if domtype(fx) = DOM_COMPLEX then
        error("expecting a real argument");
     end_if;

     //---------------------------------------
     // special cases x = 0 and x = 1
     //---------------------------------------

     if iszero(1 - x) then
        return(infinity);
     end_if;
     if iszero(x) then
        // return a float, even for exact x!
        return(float(0));
     end_if;

     //---------------------------------------
     // symbolic return for symbolic x
     //---------------------------------------

     if domtype(fx) <> DOM_FLOAT then
        // x is symbolic, nothing can be done
        return(hold(stats::fQuantile)(aa, bb)(x));
     end_if;

     //------------------------------------
     // now we are sure that x is numerical
     //------------------------------------
 
     if fx > 1 then
        error("expecting an argument 0 <= x <= 1"):
     end_if;
     if fx < 0 then
        error("expecting an argument 0 <= x <= 1"):
     end_if;
 
     //---------------------------------------------
     // now we are sure that x is numerical and 0 < x < 1
     //---------------------------------------------
 
     if domtype(fa) <> DOM_FLOAT or
        domtype(fb) <> DOM_FLOAT then
         // either a or b is symbolic.
         // Nothing can be done.
         return(hold(stats::fQuantile)(aa, bb)(x));
     end_if;
 
     //---------------------------------------------
     // use numeric::realroots to solve 
     // x = fCDF(a, b)(y)
     //   = ibeta(a/2, b/2, a*y/(b + a*y) 
     //   = 1 - ibeta(b/2, a/2, b/(b + a*y))
     // for y.
     // (Note ibeta(a, b, y) = ibeta(b, a, 1 - y) for all a, b, y.)
     // Hence, either solve
     //     ibeta(a/2, b/2, a*y/(b + a*y) = x  for y
     // or solve
     //     ibeta(b/2, a/2, b/(b + a*y) = 1 - x  for y.
     // With z = a*y/(b+a*y) or z = b/(b+a*y), we need to solve
     // either
     //     ibeta(a/2, b/2, z1) =  x   for z1
     // or
     //     ibeta(b/2, a/2, z2) = 1-x  for z2,
     // where z1 = a*y/(b+a*y),  z2 = b/(b+a*y) = 1 - z1.
     // Note that realroots just evaluates ibeta. The
     // precision of the result just depends on the
     // precision of the results returned by ibeta.
     // **********************************************
     // Since ibeta(.., .., z) is stabilized for small
     // values of z (but 1 - z suffers from cancellation for
     // z close to 1), make sure that the version is
     // used which evaluates ibeta for values of z
     // not too close too 1 (z <= 1/2, say).
     // **********************************************

     z:= genident(): 

     //-----------------------------------------------------
     // Test if the solution zz is <= 1/2.
     // If yes, use the first version,
     // otherwise, use the second version:
     //-----------------------------------------------------
     if specfunc::ibeta(aa/2, bb/2, 1/2) > fx then
        zz:= numeric::realroot(
                hold(specfunc::ibeta)(aa/2, bb/2, z) = x,
                z=0..1/2):
        // this zz is not larger than 1/2
        return(fb/fa * zz/(1 - zz));
     end_if;

     //-----------------------------------------------------
     // Problem: small solutions are computed by
     // numeric::realroot only to an *absolut* precision.
     // Make sure that the solution obtained in the following
     // branch is not smaller than 10^(-DIGITS):
     //-----------------------------------------------------

     fw:= float(1 - x):

     if specfunc::ibeta(bb/2, aa/2, 10^(-DIGITS)) < fw then
        // the following zz is 1 - (the zz above).
        // Thus, if this branch is taken, we know
        // that the following 
        // zz == z2 = 1 - z1 == 1 - (the zz above)
        // is smaller than 1/2. It is also larger
        // than 10^(-DIGITS):
        zz:= numeric::realroot(
                hold(specfunc::ibeta)(bb/2, aa/2, z) = fw,
                z = 10^(-DIGITS)..1):
        return(fb/fa * (1 - zz)/zz);
     end_if;

     //-----------------------------------------------------
     // Now, we know that the solution of
     //   ibeta(b/2, a/2, z) = 1 - x = fw
     // is smaller than 10^(-DIGITS).
     // Compute a stable solution by a straightforward
     // series expansion of ibeta:
     //  ibeta(b, a, z) 
     //  = 1/beta(b, a) * z^b/b * (1 - b*(a-1)/(b + 1)*z + O(z^2))
     //  = fw
     //  -->  z^b = beta(b, a)*b*fw *(1 + O(z))
     //  -->  z = (beta(b, a) * b * fw)^(1/b) * (1 + O(z))
     //  Result: the solution of ibeta(b/2, a/2, z) = fw is
     //  approximated by z = (beta(b/2, a/2)*b/2*fw)^(2/b):
     //-----------------------------------------------------

     //-----------------------------------------------------
     // First, we need to compute fw = float(1 - x) with a 
     // sufficient precision to make sure, it is not zero 
     // (we do know that iszero(1 - x) = FALSE due to the
     // checks above). Otherwise, there would be 
     // 'division by zero' problems below. The following
     // while loop does not only make sure that fw > 0,
     // it also guarantees that fw is sufficiently precise
     //-----------------------------------------------------

     boost:= 1:
     while fw < 10.0^(-DIGITS/2.0) do
        DIGITS:= 2*DIGITS;
        boost:= 2 * boost:
        fw:= float(1 - x):
     end_while;
     DIGITS:= DIGITS/boost;

     //-------------------------
     // now we know that fw > 0.
     //-------------------------

     fb:= fb/2: fa:= fa/2:
     zz:=  (beta(fb, fa)*fb*fw)^(1/fb);
     return(fb/fa * (1 - zz)/zz);
  end_proc:
end_proc:
