/*
Walter Oevel, 23.7.01
  - ueberarbeitet, sollte ok sein
  - Todo: - a bit more internal documentation (comments
            in the header) would be nice
          - Apart from this: OK
*/

stats::gammaQuantile:= proc(a, b)
local fa, fb;
option escape;
save DIGITS;
begin
  if args(0) <> 2 then
     error("expecting two aruments") 
   end_if:
  // ------------- check a -------------
  fa:= float(a):
  if domtype(fa) = DOM_FLOAT and fa <= 0 then
     error("the shape parameter must be positive"):
  end_if;
  if domtype(fa) = DOM_COMPLEX then
     error("the shape parameter must be real");
  end_if;

  // ------------- check b -------------
  fb:= float(b):
  if domtype(fb) = DOM_FLOAT and fb <= 0 then
     error("the scale parameter must be positive"):
  end_if;
  if domtype(fb) = DOM_COMPLEX then
     error("the scale parameter must be real");
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc(x)
  local aa, bb, fa, fb, fx, w, y, z, z0,
        macheps, macheps2, am1, tmp, P, 
        lobound, hibound;
  save DIGITS;
  begin
    if args(0)<>1 then
        error("one argument expected")
    end_if:

     // ------------- check a -------------
     aa:= context(a):
     fa:= float(aa):
     if domtype(fa) = DOM_FLOAT and fa <= 0 then
        error("the shape parameter must be positive"):
     end_if;
     if domtype(fa) = DOM_COMPLEX then
        error("the shape parameter must be real");
     end_if;

     // ------------- check b -------------
     bb:= context(b):
     fb:= float(bb):
     if domtype(fb) = DOM_FLOAT and fb <= 0 then
        error("the scale parameter must be positive"):
     end_if;
     if domtype(fb) = DOM_COMPLEX then
        error("the scale parameter must be real");
     end_if;

     // ------------- check x -------------
     fx:= float(x);
     if domtype(fx) = DOM_COMPLEX then
        error("expecting a real argument");
     end_if;
     if domtype(fx) <> DOM_FLOAT then
        // x is symbolic, nothing can be done
        return(hold(stats::gammaQuantile)(aa, bb)(x));
     end_if;

    //------------------------------------
    // now we are sure that x is numerical
    //------------------------------------

    if fx > 1 then
       error("expecting an argument 0 <= x <= 1"):
    end_if;
    if iszero(1 - x) then
       return(infinity);
    end_if;
    if iszero(x) then
       // return a float, even for exact x!
       return(float(0));
    end_if;
    if fx < 0 then
       error("expecting an argument 0 <= x <= 1"):
    end_if;

    //---------------------------------------------
    // now we are sure that x is numerical and 0 < x < 1
    //---------------------------------------------

    // --------- float evaluation ? ------------
    if domtype(fa) <> DOM_FLOAT or
       domtype(fb) <> DOM_FLOAT then
      // at least one of the parameters is symbolic, nothing can be done
      return(hold(stats::gammaQuantile)(aa, bb)(x));
    end_if:

    //-----------------------
    // do the numerical work:
    //-----------------------

    macheps:= 10.0^(-DIGITS);
    macheps2:= 10.0^(1 - DIGITS/2);
    // DIGITS:= DIGITS + 10:
    am1:= float(aa - 1):
    w:= float(1 - x):


    // ------------------------------
    // For the special case a = 1, an
    // explicit formula
    //    quantile(x) = -b*ln(1 - x) 
    // is available. Use it to make
    // this case very fast.
    // ------------------------------

    if iszero(am1) then
       if fx < macheps then 
            // do not use w = 1 - x, because
            // it's marred by cancellation:
            // -b*ln(1-x) = b *(x + x^2/2 + ..)
            return(fb*fx);
       elif fx < macheps2 then 
            // -b*ln(1-x) = b *(x + x^2/2 + ..)
            return(fb*fx*(1 + fx/2));
       elif fx < 1/100 then
            DIGITS:= round(4/3*DIGITS);
            return( - fb * ln(1 - x));
       else // in w = 1 - x, we have lost no more than 2 digits
            // (but we have at least 2 guard digits, anyway).
            return( - fb * ln(w));
       end_if;
    end_if;

    // --------------------
    // general case: a <> 1
    // --------------------

    //----------------------------------------------------------------------
    // Strategy:  solve
    //        gammaCDF(a, b)(x) = 1 - igamma(a, y/b)/gamma(a) = x
    // for small x.
    // For x close to 1, solve the equivalent equation
    //       igamma(a, y/b) = (1 - x)*gamma(a)
    //
    // For small x, we have (with small z = y/b)
    //   gammaCDF(a, b)(y) = 1 - igamma(a, y/b)/gamma(a) = x
    //   = exp(-z)*z^a/gamma(a+1) * (1 + z/(a+1) + z^2/(a+1)/(a+2) + O(z^2) )
    //   = z^a/gamma(a + 1) * (1 - z*a/(a+1) + O(z^2)
    // --> y/b = z = (gamma(a+1) * x)^(1/a),  if z < macheps.
    //
    // For x close to 1, we solve  igamma(a, y/b)/gamma(a) = (1 - x):
    // With large z = y/b we have
    //  1 - x = igamma(a, z)/gamma(a) 
    //  = exp(-z)*z^(a - 1)/gamma(a) * ( 1 + (a - 1)/z + O(1/z^2) )
    // The solution of  
    //           exp(-z)*z^(a-1) = (1 - x)*gamma(a) =: w
    // is:
    //     z:= -s*lambertW(- w^(1/s) / s);  if s = a - 1 < 0
    //     z:= -s*lambertV(- w^(1/s) / s);  if s = a - 1 > 0
    //                                      and s^s*exp(-s) >= w
    // Note that for s >= exp(1), s^s*exp(-s) >= 1.
    // s = 1 is the minimum of s^s*exp(-s) attaining the value
    // exp(-1) ---> make sure that w < exp(-1) = 0.3678...
    // If this is granted,  z^s *exp(-z) = w always has
    // a solution z for any s > 0.

    // Some facts:
    // gammaCDF(a, 1)(a) is >= 1/2 for all a > 0
    // --> gammaQuantile(a, b)(1/2) <= b*a for all a>0, b> 0.
    // --> gammaQuantile(a, b)( x ) <= b*a for all a>0, b> 0, x <= 1/2
    //
    // gammaCDF(a, 1)(2*a) >= 0.84 for all a > 0
    // --> gammaQuantile(a, b)(0.84) <= 2*b*a for all a>0, b> 0.
    // --> gammaQuantile(a, b)( x  ) <= 2*b*a for all a>0, b> 0, x <= 0.84
    // ----------------------------------------------------------------------
    /*
       if x < 84/100 then
          hibound:= 2*bb*aa
       elif x <= 1/2 then
          hibound:= bb*aa
       end_if;
     */
    //----------------------------------------------------------------------

    // ------------------------
    // Case 1:  x is very small
    // ------------------------

    // -------------------------------------------------------------
    // For z = y/b:
    //      z^a =  gamma(a + 1)*x/(1 - z*a/(a + 1) + O(z^2))
    // -->  z   = (gamma(a + 1)*x/(1 - z*a/(a + 1) + O(z^2)) )^(1/a)
    //          = (gamma(a + 1)*x)^(1/a) / (1 - z/(a + 1) + O(z^2))
    //          = (gamma(a + 1)*x)^(1/a) * (1 + z/(a + 1) + O(z^2))
    // -->  z = (gamma(a+1) * x)^(1/a),  if z is very small
    // -------------------------------------------------------------
    z:= (gamma(fa + 1) * fx)^(1/fa):
    if z < macheps then
       return(fb*z);
    end_if;
    // do one step of the Banach iteration
    if z < macheps2 then
       return(fb*z*(1 + z/(fa + 1)));
    end_if;

    // -------------------------------
    // here we know that the solution is larger
    // than b*macheps2 =  b*sqrt(macheps).
    // -------------------------------

    // -------------------------------
    // Case 2:  x is smaller than 0.84
    // -------------------------------

    y:= genident();
    P:= stats::gammaCDF(fa, fb);

    if P(fa*fb/2) >= fx then
          // We know that the solution satisfies y <= a*b/2 
         lobound:= fb*macheps2;
         // hibound:= fa*fb/2;
    else 
         // We know that the solution satisfies y > a*b/2 
         lobound:= max(fb*macheps2, fa*fb/2):
    end_if;
  
    if fx <= 1/2 then
       // We know that the solution satisfies y <= a*b 
       // Note that P(a, y/b) = stats::gammaCDF(a, b)(y) is stabilized
       // for small arguments, so it is safe to use
       // gammaCDF and numeric::realroot!
       return(numeric::realroot(P(y) = x, y = lobound .. fa*fb));
    end_if;

    if fx <= 84/100 then
       // we know that the solution satisfies y <= 2*a*b 
       return(numeric::realroot(P(y) = x, y = lobound .. 2*fa*fb));
    end_if;


    // -----------------------------------
    // x is larger than 0.84, 1 - x < 0.16
    // -----------------------------------

    //---------------------------------------------------------------
    // For x close to 1, we solve 
    //       igamma(a, y/b)/gamma(a) = (1 - x) =: w/gamma(a)
    // With large z = y/b, we have
    //  w = igamma(z)
    //  = exp(-z)*z^(a - 1) * ( 1 + (a - 1)/z + O(1/z^2) )
    // The solution of 
    //           exp(-z)*z^(a-1) = w
    // is:
    //     z:= -s*lambertW(- w^(1/s) / s);  if s = a - 1 < 0
    //     z:= -s*lambertV(- w^(1/s) / s);  if s = a - 1 > 0
    // 
    // For s < 0, there is always a solution.
    // For s > 0, a solution exists iff
    //       s^s*exp(-s) >= w  
    // i.e,
    //       s*exp(-1) >= w^(1/s).
    //
    // Note that s^s*exp(-s) >= 1^1*exp(-1) = 0.3678... for all s > 0,
    // i.e., we know that s^s*exp(-s) >= w only, if
    // w = (1 - x)*gamma(a) < 0.3678, i.e., if
    // 1 - x < 0.3678/gamma(a).
    // If a >> 1, this is satisfied only for 
    // extremely (ridiculously) small values of 1 - x.
    //---------------------------------------------------------------

    w:= gamma(fa)*w:

    tmp:= w^(1/am1)/am1:
    if am1 < 0 then
         z0:= -am1*lambertW(-tmp);
    else 
         // Make sure that a solution of exp(-z)*z^am1 = w exists:
         //     exp(-am1)*am1^am1 >= w 
         // --> exp(-1)* am1 >= w^(1/am1)
         // --> exp(-1) >= w^(1/am1)/am1 = tmp
         // If not, use the default value z0 = a:
         if exp(-float(1)) > tmp then
              z0:= -am1*lambertW(-1, -tmp); 
         else z0:= fa;
         end_if;
    end_if;

    if domtype(z0) <> DOM_FLOAT then
       error("this should not happen");
    end_if;

    // The lambert{V,W} expressions z0 both satisfy
    //    exp(-z0)*z^(a - 1) = w,
    // --> - z0 + (a-1)*ln(z0) = ln(w)
    // --> z0 = -ln(w) + (a-1)*ln(z0)


    // -------------------------------
    // Case 3:  1 - x << 1
    // -------------------------------

    // This following part of the code can hardly be reached!
    // We would need 0 < a - 1 <  a /10^(DIGITS:
    if z0 >= abs(am1)/macheps then
       // the approximation z0 is correct within
       // working precision, i.e., y = b*z is the solution
       return(fb*z0);
    end_if;

    /*-------------------------------------------------------- 
    // obsolete code: for a = 1 + epsilon, the following
    // does not achieve the desired precision!
    
    if z0 >= abs(am1)/macheps2 then
       // We are solving the equation
       // exp(-z)*z^(a - 1)*(1 + (a-1)/z + O(1/z^2)) = w
       // --> exp(z) = 1/w * z^(a - 1) * ( 1 + (a-1)*z + O(1/z^2) )
       // --> z = -ln(w) + (a-1)*ln(z) + ln(1 + (a-1)/z + O(1/z^2))
       // --> z = -ln(w) + (a-1)*ln(z) + (a-1)/z + O(1/z^2)
       //        |------ z0 ---------| 
       // Do one step of the Banach-Iteration.
       // With the approximation z0 of this equation,
       // we have to replace z0 --> z0 + (a-1)/z0
       return(fb*(z0 + am1/z0));
    end_if;
    --------------------------------------------------------*/

    // -------------------------------
    // Case 4: moderate values of  1 - x (< 0.16)
    // -------------------------------

    //-------------------------------------------------
    // We construct a verified bracket for the solution:
    //
    // We solve igamma(a, y/b)/gamma(a) = 1 - x
    // via numeric::realroots. Return y = b*z with
    //    igamma(a, z) = gamma(a) * (1 - x) =: w
    // We need a bracket [lobound, hibound] for z.
    // Start with an approximation z0 and check
    // whether it is too large or too small.
    // If z0 is too large, half z0 iteratively until
    // a lower bound is found.
    // If z0 is too small, double z0 iteratively until
    // an upper bound is found.
    //----------------------------------------------------------
    //-------------------------------------------------
    // If the asymptotic approximation is very large,
    // we use it as a starting point. Otherwise,
    // put z0 = 2*a (this is where most of the action is
    // and allow for some overestimation).
    //-------------------------------------------------

    if z0 < specfunc::abs(am1)/2 then 
         // with |a - 1| / z0 > 1, the asymptotic
         // approximation z0 is not realistic.
         // Expect most of the action in the range a..2*a
         z0:= fa:
    else // accept the asymptotic approximation z0:
         // z0:= z0:
    end_if;

    //----------------------------------------------------------
    // Note that igamma(a, z) is monotonically *decreasing* in z!
    //----------------------------------------------------------
    if igamma(fa, z0) <= w then
         // the solution z satisfies z <= z0
         hibound:= z0:
         lobound:= hibound:
         repeat
           lobound:= lobound/2;
         until igamma(fa, lobound) >= w end_repeat;
         hibound:= 2*lobound;
    else
         // the solution z satisfies z >= z0
         lobound:= z0:
         hibound:= lobound;
         repeat
           hibound:= 2*hibound;
         until igamma(fa, hibound) <= w end_repeat;
         lobound:= hibound/2:
    end_if;

    // the following y is the z of the comments:
    // (but we already have a symbolic identifier y)

    return(fb*numeric::realroot(
               hold(igamma)(fa, y) = w,
               y = lobound .. hibound)
           );

    /*----------------------------------------------------------
    // obsolete code. This part does a plain Newton search for
    // the solution of igamma(fa, z) = w starting at z = k.

    z:=  z0;
    dz:= z;

    // make sure, that b*z is given to relative/absolute precision
    // macheps, i.e., use 1/fb + |z| instead of the usual switch
    // 1 + |z| between relative and absolute precision

    while specfunc::abs(dz) >= macheps*(1/fb + specfunc::abs(z)) do
      k:= w - igamma(fa, z): // we are solving igamma(fa, z) = w
      if specfunc::abs(k) <= macheps*w then
         break;
      end_if;
      dz:= k/(z^am1*exp(-z));
      z:= z - dz;
    end_while;
    return(float(fb*z))
    ----------------------------------------------------------*/
 end_proc:
end_proc:
