/* ----------------------------------------------------
Walter Oevel, 26.8.01
  - ueberarbeitet, sollte ok sein
  - Todo: - a bit more internal documentation (comments
            in the header) would be nice
          - Apart from this: OK
---------------------------------------------------- */

stats::logisticQuantile:=proc(m, s)
local fm, fs;
option escape;
begin
  if args(0)<>2 then 
     error("expecting two arguments")
  end_if:
  // ------------- check m -------------
  fm:= float(m):
  if domtype(fm) = DOM_COMPLEX then
     error("the mean must be real");
  end_if;

  // ------------- check s -------------
  fs:= float(s):
  if domtype(fs) = DOM_FLOAT and fs <= 0 then
     error("the standard deviation must be positive"):
  end_if;
  if domtype(fs) = DOM_COMPLEX then
     error("the standard deviation must be real");
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc(x)
  local mm, fm, ss, fs, fx, u;
  begin
    if args(0)<>1 then
      error("expecting one argument")
    end_if:

    // ------------- check m -------------
    mm:= context(m):
    fm:= float(mm):
    if domtype(fm) = DOM_COMPLEX then
       error("the mean must be real");
    end_if;

    // ------------- check s -------------
    ss:= context(s):
    fs:= float(ss):
    if domtype(fs) = DOM_FLOAT and fs <= 0 then
       error("the standard deviation must be positive"):
    end_if;
    if domtype(fs) = DOM_COMPLEX then
       error("the standard deviation must be real");
    end_if;

    // ------------- check x -------------
    fx:= float(x);
    if domtype(fx) = DOM_COMPLEX then
       error("expecting a real argument");
    end_if;

    if domtype(fx) <> DOM_FLOAT then
       // x is symbolic, return the symbolic result
       u:= sqrt(3)*ss/PI:
       return(mm + u*ln(x/(1 - x))):
    end_if;

    //------------------------------------
    // now we are sure that x is numerical
    //------------------------------------

    if fx > 1 then
       error("expecting an argument 0 <= x <= 1"):
    end_if;
    if iszero(1 - x) then
       return(infinity);
    end_if;
    if iszero(x) then
       return(-infinity);
    end_if;
    if fx < 0 then
       error("expecting an argument 0 <= x <= 1"):
    end_if;

    //---------------------------------------------
    // now we are sure that x is numerical and 0 < x < 1
    //---------------------------------------------

    // --------- float evaluation ? ------------
    if domtype(x) = DOM_FLOAT then
         u:= float(3^(1/2)/PI)*fs:
         return(fm + u*ln::float(float(x/(1 - x)))):
    else u:= sqrt(3)*ss/PI:
         return(mm + u*ln(x/(1 - x))):
    end_if;
  end_proc:
end_proc:
