/*
Walter Oevel, 22.8.01
  - ueberarbeitet, sollte ok sein
  - Todo: - a bit more internal documentation (comments
            in the header) would be nice
          - Apart from this: OK
*/


stats::tQuantile:=proc(a)
local fa;
option escape;
begin
  if args(0)<>1 then
     error("expecting one argument")
  end_if:

  // ------------- check a -------------
  fa:= float(a):
  if domtype(fa) = DOM_FLOAT and fa <= 0 then
     error("the shape parameter must be positive"):
  end_if;
  if domtype(fa) = DOM_COMPLEX then
     error("the shape parameter must be real");
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc(x)
  local aa, fa, fx, z, s, fw;
  begin
     if args(0) <> 1 then
        error("expecting one argument")
     end_if:

     // ------------- check a -------------
     aa:= context(a):
     fa:= float(aa):
     if domtype(fa) = DOM_FLOAT and fa <= 0 then
        error("the shape parameter must be positive"):
     end_if;
     if domtype(fa) = DOM_COMPLEX then
        error("the shape parameter must be real");
     end_if;

     // ------------- check x -------------
     fx:= float(x);
     if domtype(fx) = DOM_COMPLEX then
        error("expecting a real argument");
     end_if;

     //--------------------------
     // special cases:
     //--------------------------

     if iszero(1 - x) then
        return(infinity)
     end_if:
     if iszero(x) then 
        return(-infinity)
     end_if:
     if iszero(x - 1/2) then
        // return a float, even for exact x = 1/2!
        return(float(0))
     end_if;

    //------------------------------------
    // symbolic return?
    //------------------------------------
     if domtype(fx) <> DOM_FLOAT then
        // x is symbolic, nothing can be done
        return(hold(stats::tQuantile)(aa)(x));
     end_if;

    //------------------------------------
    // now we are sure that x is numerical
    //------------------------------------

    if fx > 1 then
       error("expecting an argument 0 <= x <= 1"):
    end_if;
    if iszero(1 - x) then
       return(infinity);
    end_if;
    if iszero(x) then
       // return a float, even for exact x!
       return(float(0));
    end_if;
    if fx < 0 then
       error("expecting an argument 0 <= x <= 1"):
    end_if;

    //---------------------------------------------
    // now we are sure that x is numerical and 0 < x < 1
    //---------------------------------------------

    // --------- float evaluation ? ------------
    if domtype(fa) <> DOM_FLOAT then
      // shape parameter a is symbolic, nothing can be done
      return(hold(stats::tQuantile)(aa)(x));
    end_if:

    // Now, both a and x are known to be numerical.
    // The floating point job starts:

    // -------------------------------------------------------
    // We need to solve  tCDF(a)(y) = x:
    // case 1)  0 <= x < 1/2,  |x| << 1/2
    //     tCDF(a)(y) = 1/2*ibeta(a/2, 1/2, a/(a + y^2)) = x
    // case 2)  0 < x < 1/2,  |x - 1/2| << 1
    //     tCDF(a)(y) = 1/2 - 1/2*ibeta(1/2, a/2, y^2/(a + y^2)) = x
    // case 3)  1/2 < x < 1, |x - 1/2| << 1
    //     tCDF(a)(y) = 1/2 + 1/2*ibeta(1/2, a/2, y^2/(a + y^2)) = x
    // case 4)  1/2 < x <= 1,  |x - 1| << 1
    //     tCDF(a)(y) = 1 - 1/2*ibeta(a/2, 1/2, a/(a + y^2)) = x
    // -------------------------------------------------------

    // -------------------------------------------------------
    // cases 2 + 3: numerical stabilization for x approx 0.5.
    // Here the result is small, so special measures are needed
    // to assure a good *relative* precision of the result.
    // We need to solve
    //  tCDF(a)(y) = 1/2 -/+ 1/2*ibeta(1/2, a/2, y^2/(a + y^2) = x
    //  -->   ibeta(1/2, a/2, z) = |1 - 2*x|
    //  where z = y^2/(a + y^2) and |1 - 2*x| << 1.
    //
    //  If |z| << 1, 
    //    ibeta(1/2, a/2, z) = 2*fw
    //   -->  2*z^(1/2) + (2-a)/3*z^(3/2) + .. = 2*|1/2-x| = 2*fw*beta(1/2, a/2)
    //   -->  2*x^(1/2) * ( 1 + (2-a)/6*x + ... ) = 2*fw*beta(1/2, a/2)
    //   -->    z = (fw*beta(1/2, a/2)^2
    //  If (2-a)/6*z < 10^(-DIGITS), this is the result:

    fw:= fx - 1/2:
    if specfunc::abs(fw) < 0.1 then
      s:= 1:
      if fw < 0 then 
         s:= -1:
         fw:= -fw:
      end_if;
      z:= (fw*beta(1/float(2), fa/2))^2: 
      // if |2-a|*z < 6*10^(-DIGITS), this is the solution. 
      if specfunc::abs(2-fa)*z < 6*10^(-DIGITS)
         and not iszero(1 - z) then
         // z = y^2/(a + y^2) --> y^2 = a*z/(1 - z)
         return(s*(z*fa/(1 - z))^(1/2));
      end_if;
    end_if;
         
    // -------------------------------------------------------
    // case 1)  0 <= x < 1/2,  |x| << 1/2
    //     tCDF(a)(y) = 1/2*ibeta(a/2, 1/2, a/(a + y^2)) = x
    // and
    // case 4)  1/2 < x <= 1,  |x - 1| << 1
    //     tCDF(a)(y) = 1 - 1/2*ibeta(a/2, 1/2, a/(a + y^2)) = x
    // We now need to solve
    //      ibeta(a/2, 1/2, a/(a+y^2)) = fw
    //  where y is the quantile value that has to be returned.
    //  Solve
    //      ibeta(a/2, 1/2, z) = fw
    //  and return  y = sqrt(a/z - a)
    //    
    //  Problem:  numeric::realroot(beta(a/2,1/2,z) = fw)
    //            computes the solution |z| << 1 only to an
    //            absolute precision of 10^(-DIGITS).
    //            If a is very small, this is not sufficient,
    //            because z is proportional to fw^(2/a).
    //            Hence, we need to treat this case specially:
    // Rationale: For |z| << 1,
    //  beta(a/2, 1/2)* ibeta(a/2,1/2,z)
    //    = z^(a/2)/(a/2) + z^(a/2 +1)/2/(a/2 + 1) + ...
    //    = z^(a/2)/(a/2) * ( 1 + a*z/(2*a + 1) + ...)
    // For small fw, the solution of ibeta(a/2, 1/2, z) = fw is
    // approximately  z = (a/2*beta(a, b)*fw)^(2/a). It is correct up to
    // DIGITS decimal places, if
    //   a*z/(2*a + 1)  < 10^(-DIGITS), i.e., if  z < (2 + 1/a)*10^(-DIGITS)
    // -------------------------------------------------------

    if fx < 1/2 then
       s:= -1; 
       fw:= 2*fx;
     else 
       s:= 1;
       fw:= 2*float(1 - x); 
     end_if:

     z:= (fa*beta(fa/2, 1/2)*fw/2)^(2/fa);

     // If z is small enough, this is the solution.
     // Otherwise, we need to compute the solution via realroot:
     if z > (2 + 1/fa)*10^(-DIGITS) then
        z:=genident():
        z:= numeric::realroot(hold(specfunc::ibeta)(aa/2,1/2,z)=fw,
                              z = 0..1):
     end_if;
     if iszero(z) then
        return(s*infinity);
     end_if:
     s*abs(fa*(1/z - 1))^(1/2);
   end_proc:
end_proc:
