/*
Walter Oevel, 25.7.01
  - ueberarbeitet, sollte ok sein
  - Todo: - a bit more internal documentation (comments
            in the header) would be nice
          - Apart from this: OK
*/

stats::uniformQuantile:=proc(a, b)
local fa, fbma;
option escape;
begin
  if args(0) <> 2 then
     error("expecting two arguments")
  end_if:

  // ------------- check a -------------
  fa:= float(a):
  if domtype(fa) = DOM_COMPLEX then
     error("the left border must be real");
  end_if;

  // ------------- check b -------------
  if domtype(float(b)) = DOM_COMPLEX then
     error("the right border must be real");
  end_if;

  fbma:= float(b - a):

  if domtype(fbma) = DOM_FLOAT and fbma < 0 then
     error("the left border must not exceed the right border"):
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------

  proc(x)
  local aa, fa, bb, fb, bma, fbma, fx;
  begin
    if args(0) <> 1 then
       error("one argument expected")
    end_if:

     // ------------- check a -------------
     aa:= context(a):
     fa:= float(aa):
     if domtype(fa) = DOM_COMPLEX then
        error("the left border must be real");
     end_if;

     // ------------- check b -------------
     bb:= context(b):
     fb:= float(bb):
     if domtype(fb) = DOM_COMPLEX then
        error("the right border must be real");
     end_if;

     //-------------------------------------
     bma:= bb - aa;
     fbma:= float(bma):

     if domtype(fbma) = DOM_FLOAT and fbma < 0 then
        error("the left border must not exceed the right border"):
     end_if;

     // ------------- check x -------------
     fx:= float(x);
     if domtype(fx) = DOM_COMPLEX then
        error("expecting a real argument");
     end_if;

     if domtype(fx) = DOM_FLOAT then
        if fx > 1 or fx < 0 then
           error("expecting an argument 0 <= x <= 1"):
        end_if;
     end_if;

     // ----- return the quantile value
     if domtype(x) = DOM_FLOAT then
          return(fa + x*fbma);
     else return(aa + x*bma);
     end_if;
 end_proc:
end_proc:
