/*
!!! There is also the undocumented calling syntax
    stats::binomialRandom(a, b, frandom)
    stats::binomialRandom(a, b, frandom(n))
    This is needed by poissonRandom(m, Seed = n) which
    has to call binomialRandom with an initialized UC(0, 1) generator
!!!
*/

stats::binomialRandom:= proc(n, p)
local fp, fn, rand;
option escape;
begin
  if args(0) < 2 then
     error("expecting at least two arguments")
  end_if:
  if args(0) > 3 then 
     error("expecting no more than three arguments")
  end_if:

  // ------------- check p -------------
  fp:= float(p):
  if domtype(fp) = DOM_FLOAT then
     if fp < 0 or fp > 1 then
        error("the 'probability parameter' p must satisfy 0 <= p <= 1"):
     end_if;
  end_if;
  if domtype(fp) = DOM_COMPLEX then
     error("the 'probability parameter' must be real"):
  end_if;

  // ------------- check n -------------
  fn:= float(n);
  if domtype(n) = DOM_INT and n < 1 then
     error("the 'trial parameter' must be symbolic or an integer >= 1"):
  end_if;
  if domtype(fn) = DOM_FLOAT and domtype(n) <> DOM_INT then
     error("the 'trial parameter' must be symbolic or an integer >= 1"):
  end_if;
  if domtype(fn) = DOM_COMPLEX then
     error("the 'trial parameter' must be real"):
  end_if;

  // -----------  check option Seed = s ---------------
  if args(0)=3 then
    if {domtype(args(3))} minus {DOM_PROC, DOM_FUNC_ENV} = {} then
          // a UC(0,1) generator frandom (DOM_FUNC_ENV)
          // or frandom(seed) (DOM_PROC) was passed as
          // third argument:
         rand:= args(3):
    elif type(args(3))<>"_equal" then
         error("the 3rd argument must be of the form 'Seed = integer' or 'Seed = CurrentTime'"):
    elif op(args(3),1)<>Seed then
         error("the 3rd argument must be of the form 'Seed = integer' or 'Seed = CurrentTime'"):
    elif domtype(op(args(3),2))<>DOM_INT and op(args(3), 2)<>CurrentTime then
         error("the 3rd argument must be of the form 'Seed = integer' or 'Seed = CurrentTime'"):
    else rand:= frandom(op(args(3), 2))
    end_if:
  else
    rand:= frandom:
  end_if:

  // ------ special cases p = 0 and p = 1 -------
  if domtype(n) <> DOM_INT then
      if iszero(p) then
         return(() -> 0);
      end_if;
      if iszero(1 - p) then
         return(() -> n);
      end_if;
  end_if;

  // ------ unevaluated return ? --------
  if domtype(n)  <> DOM_INT or
     domtype(fp) <> DOM_FLOAT
  then
    if args(0) = 2 then
         return(procname(args()));
    else // do not accept symbolic n and/or p in conjunction
         // with Seed = s, because otherwise the following would
         // happen:
         // delete a, b: f:= stats::XXXRandom(a, b, Seed = 1):
         // a:= 1: b:= 2: f(), f(), f()
         //     -1.506518279, -1.506518279, -1.506518279
         error("all parameters must be numerical ".
               "if 'Seed = ...' is specified"):
    end_if;
  end_if:

  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc()
  local r;
  begin

    // r = random generator for Bi(n, fp) variates.
    // Recursively calls Bi(a-1, fp') or Bi(b-1, fp'),
    // where a, b are approximately n/2
    r:= proc(n, fp)
    local i, a, b, X;
    name stats::binomialRandom::recursive;
    begin
      if n < 101 then
         // For sufficiently small n:
         // Choose n UC(0,1) numbers and count
         // how many of them are less than p:

         // the following version is fast, but
         // may use lots of memory for large n.
         // Note that, typically, long lists of
         // random numbers will be created by
         // the user!

         return(nops(select([rand() $ i=1..n], _less, fp)));

         // the following would use less memory:
         /*
         count:= 0:
         for i from 1 to n do
             if rand() < fp then
                count:= count + 1;
             end_if;
         end_for;
         return(count);
         */
      end_if;
  
      // If n is large, use the method as described in
      // D. Knuth, Seminumerical Algorithms, p. 136;
      // Reduce Bi(n, p) to Bi(n/2, p') recursively.
      // This amounts to a runtime of O(ln(n)):

      a := 1 + trunc(n/2):
      b := n + 1 - a;
      // pass the UC(0, 1) generator rand = frandom or frandom(seed)
      // to stats::betaRandom to make sure that also with Seed = seed
      // random beta deviates are produced
      X:= stats::betaRandom(a, b, rand)():
      if X >= fp 
      then return(    r(a - 1,  fp/X) );
      else return(a + r(b - 1, (fp - X)/(1-X)) );
      end_if;
    end_proc:

    // call the recursive binomialRandom

    r(n, fp);

  end_proc:
end_proc:
