//this procedure computes cauchy deviates with real parameters a,b ;
//for given a,b,  f:=cauchyRandom(a,b) calls the generator; f() returns the
//random numbers

/*
Walter Oevel, 17.7.01
  - ueberarbeitet, sollte ok sein
  - Todo: - a bit more internal documentation (comments
            in the header) would be nice
          - Apart from this: OK
*/

stats::cauchyRandom:=proc(a, b)
local r, fa, fb;
option escape;
begin
  if args(0)<2 then
     error("expecting at least two arguments")
  end_if:
  if args(0)>3 then 
     error("expecting no more than three arguments")
  end_if:

  // ------------- check a -------------
  fa:= float(a):
  if domtype(fa) = DOM_COMPLEX then
     error("the median must be real");
  end_if;

  // ------------- check b -------------
  fb:=float(b):
  if domtype(fb) = DOM_FLOAT and fb <= 0 then
     error("the scale parameter must be positive"):
  end_if;
  if domtype(fb) = DOM_COMPLEX then
     error("the scale parameter must be real");
  end_if;

  // -----------  check option Seed = s ---------------
  if args(0)=3 then
    if type(args(3))<>"_equal" then
       error("the 3rd argument must be of the form 'Seed = integer' or 'Seed = CurrentTime'"):
    end_if:
    if op(args(3),1)<>Seed then
       error("the 3rd argument must be of the form 'Seed = integer' or 'Seed = CurrentTime'"):
    end_if:
    if domtype(op(args(3),2))<>DOM_INT and op(args(3), 2)<>CurrentTime then
       error("the 3rd argument must be of the form 'Seed = integer' or 'Seed = CurrentTime'"):
    end_if:
  end_if:

  // ------ unevaluated return ? --------
  if domtype(fa) <> DOM_FLOAT or
     domtype(fb) <> DOM_FLOAT
  then
    if args(0) = 2 then
         return(procname(args()));
    else // do not accept symbolic a and/or b in conjunction
         // with Seed = s, because otherwise the following would
         // happen:
         // delete a, b: f:= stats::XXXRandom(a, b, Seed = 1):
         // a:= 1: b:= 2: f(), f(), f()
         //     -1.506518279, -1.506518279, -1.506518279
         error("all parameters must be numerical ".
               "if 'Seed = ...' is specified"):
    end_if;
  end_if:

  //produce an uc(0,1) random generator: 
  if args(0)=3 then
       r:=frandom(op(args(3),2)):
  else r:=frandom:
  end_if:

  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc()
  local k;
  begin:
    // r() produces values in [0, 1).
    // It is unlikely that r() - 1/2 = -1/2,
    // so do not bother to use traperror
    // (which would double the runtime of 
    //  the generator).
    k:=float(PI)*(r()- 1/2):
    return(fb*tan::float(k) + fa);
  end_proc:
end_proc:
