// this procedure computes chisquare deviates
// with parameter m > 0 ;
// f:=chisquareRandom(m) calls the generator;
// f() returns the random numbers;

stats::chisquareRandom:= proc(m)
local fm;
option escape;
begin
  if args(0) < 1 then
     error("expecting at least one argument")
  end_if:
  if args(0) > 2 then
     error("expecting no more than two arguments")
  end_if:

  // ------------- check m -------------
  fm:= float(m):
  if domtype(fm) = DOM_COMPLEX then
     error("the mean must be real");
  end_if;
  if  domtype(fm) = DOM_FLOAT and fm<=0  then
      error("the mean must be positive")
  end_if:

  // -----------  check option Seed = s ---------------
  if args(0)=2 then
    if type(args(2))<>"_equal" then
       error("the 2nd argument must be of the form 'Seed = integer' or 'Seed = CurrentTime'"):
    end_if:
    if op(args(2),1)<>Seed then
       error("the 2nd argument must be of the form 'Seed = integer' or 'Seed = CurrentTime'"):
    end_if:
    if domtype(op(args(2),2))<>DOM_INT and op(args(2),2)<>CurrentTime then
       error("the 2nd argument must be of the form 'Seed = integer' or 'Seed = CurrentTime'"):
    end_if:
  end_if:

  // ------ unevaluated return ? --------
  if domtype(fm)  <> DOM_FLOAT then
    if args(0) = 1 then
         return(procname(args()));
    else // do not accept symbolic m in conjunction
         // with Seed = s, because otherwise the following would
         // happen:
         // delete m: f:= stats::XXXRandom(m, Seed = 1):
         // m:= 1:  f(), f(), f()
         //     -1.506518279, -1.506518279, -1.506518279
         error("the mean must be numerical ".
               "if 'Seed = ...' is specified"):
    end_if;
  end_if:

  //-------------------------------
  // return the following procedure
  //-------------------------------
  if args(0) = 2 then
       return(stats::gammaRandom(m/2, 2, args(2))): 
  else return(stats::gammaRandom(m/2, 2)):
  end_if:
end_proc:
