/*-----------------------------------------------------------
Walter Oevel, 25.8.01
  - ueberarbeitet, sollte ok sein
  - Todo: - a bit more internal documentation (comments
            in the header) would be nice
          - Apart from this: OK
-----------------------------------------------------------*/
/*
!!! There is also the undocumented syntax
    stats::fRandom(a, b, frandom)
    stats::fRandom(a, b, frandom(Seed = n))

    This in case, future random generators would need
    to call stats::fRandom with an initialized UC(0, 1) generator
!!!
*/

stats::fRandom:=proc(a, b)
local fa, fb, x1, x2, r;
option escape;
begin
  if args(0)< 2 then
     error("expecting at least two arguments")
  end_if:
  if args(0)> 3 then
     error("expecting no more than three arguments")
  end_if:

  // ------------- check a -------------
  fa:= float(a):
  if domtype(fa) = DOM_FLOAT and fa <= 0 then
     error("the first shape parameter must be positive"):
  end_if;

  // ------------- check b -------------
  fb:= float(b):
  if domtype(fb) = DOM_FLOAT and fb <= 0 then
     error("the second shape parameter must be positive"):
  end_if;

  // -----------  check option Seed = s ---------------
  if args(0)=3 then
       if {domtype(args(3))} minus {DOM_PROC, DOM_FUNC_ENV} = {} then
            // a UC(0,1) generator frandom (DOM_FUNC_ENV)
            // or frandom(seed) (DOM_PROC) was passed as
            // third argument:
            r:= args(3):
       elif type(args(3))<>"_equal" then
            error("the 3rd argument must be of the form 'Seed = integer' or 'Seed = CurrentTime'"):
       elif op(args(3),1)<>Seed then
            error("the 3rd argument must be of the form 'Seed = integer' or 'Seed = CurrentTime'"):
       elif domtype(op(args(3),2))<>DOM_INT and op(args(3),2)<>CurrentTime then
            error("the 3rd argument must be of the form 'Seed = integer' or 'Seed = CurrentTime'"):
       else r:= frandom(op(args(3), 2));
       end_if;
  else r:= frandom:
  end_if:

  // ------ unevaluated return ? --------
  if domtype(fa) <> DOM_FLOAT or
     domtype(fb) <> DOM_FLOAT
  then
    if args(0) = 2 then
         return(procname(args()));
    else // do not accept symbolic a and/or b in conjunction
         // with Seed = s, because otherwise the following would
         // happen:
         // delete a, b: f:= stats::XXXRandom(a, b, Seed = 1):
         // a:= 1: b:= 2: f(), f(), f()
         //     -1.506518279, -1.506518279, -1.506518279
         error("all parameters must be numerical ".
               "if 'Seed = ...' is specified"):
    end_if;
  end_if:

  //produce suitable gammagenerators:
  if args(0)=3 then
     x1:=stats::gammaRandom(a/2, 1, r):
     x2:=stats::gammaRandom(b/2, 1, r): 
  else
     x1:=stats::gammaRandom(a/2, 1):
     x2:=stats::gammaRandom(b/2, 1):
  end_if:

  //-------------------------------
  // return the following procedure
  // See: Knuth, Seminumerical Algorithms, Vol. 2
  //-------------------------------
  proc()
  local r;
  begin
     r:= x2():
     if iszero(r) then 
        if fb > float(2) then
             return(fb/(fb-2))
        else return(fb)
        end_if:
     end_if:
     fb*x1()/r/fa;
  end_proc:
end_proc:
