/* -------------------------------------------------------------------------
Stephan Huckemann Nov.5.01
random generator for hypergeometricly distributed numbers
of the hypergeometric distribution with
population size N, X successes in entire population and sample size n,
= binomial(X, x)* binomial(N-X, n-x) / binomial(N, n)

The numbers are generated as follows
................

-------------------------------------------------------------------------*/

stats::hypergeometricRandom:=proc(N, X, n)

local fN, fX, fn, rand;

option escape;
begin

//prog::check(stats::hypergeometricRandom,6);

   if args(0) < 3 then
     error("expecting at least three arguments")
  end_if:
  if args(0) > 4 then 
     error("expecting no more than four arguments")
  end_if:

  // ------------- check N -------------
  fN := float(N);
  if domtype(N) = DOM_INT and N < 1 then
     error("the 'population size' must be symbolic or a positive integer"):
  end_if;
  if domtype(fN) = DOM_FLOAT and domtype(N) <> DOM_INT then
     error("the 'population size' must be symbolic or a positive integer"):
  end_if;
  if domtype(fN) = DOM_COMPLEX then
     error("the 'population size' must be real"):
  end_if;
  
 // ------------- check X -------------
  fX := float(X);
  if domtype(X) = DOM_INT then
	if X < 0 or (domtype(N)= DOM_INT and X > N) then
	     error("the 'success population size' must be symbolic or an integer".
		" between 0 and 'population size'"):
	end_if;
  end_if;
  if domtype(fX) = DOM_FLOAT and domtype(X) <> DOM_INT then
	     error("the 'success population size' must be symbolic or an integer".
		" between 0 and 'population size'"):  
  end_if;
  if domtype(fX) = DOM_COMPLEX then
     error("the 'success population size' must be real"):
  end_if;
 
 // ------------- check n -------------
  fn := float(n);
  if domtype(n) = DOM_INT then
	if n < 0 or (domtype(N) = DOM_INT and n > N) then
	     error("the 'sample size' must be symbolic or an integer".
		" between 0 and 'population size'"):
	end_if;
  end_if;
  if domtype(fn) = DOM_FLOAT and domtype(n) <> DOM_INT then
     error("the 'sample size' must be symbolic or an integer".
	" between 0 and 'population size'"):
  end_if;
  if domtype(fn) = DOM_COMPLEX then
     error("the 'sample size' must be real"):
  end_if;
 
  // -----------  check option Seed = s ---------------
  if args(0)=4 then
    if {domtype(args(4))} minus {DOM_PROC, DOM_FUNC_ENV} = {} then
          // a UC(0,1) generator frandom (DOM_FUNC_ENV)
          // or frandom(seed) (DOM_PROC) was passed as
          // fourth argument:
         rand:= args(4):
    elif type(args(4))<>"_equal" then
         error("the 4th argument must be of the form 'Seed = integer' or 'Seed = CurrentTime'"):
    elif op(args(4),1)<>Seed then
         error("the 4th argument must be of the form 'Seed = integer' or 'Seed = CurrentTime'"):
    elif domtype(op(args(4),2))<>DOM_INT and op(args(4),2)<>CurrentTime then
         error("the 4th argument must be of the form 'Seed = integer' or 'Seed = CurrentTime'"):
    else rand:= frandom(op(args(4), 2))
    end_if:
  else
    rand:= frandom:
  end_if:

 // ---------- some special cases ---- 
 // we allow symbolic in- and out-put. is that o.k.?
 // we get also the output "() -> n" or "() -> 0" ist that what we want?


   if iszero(n) or iszero(X) then // X = 0 or n = 0 implies that Random = 0
         return(() -> 0);
   end_if;

   if iszero(X-N) then // X = N, then Random = n
         return(() -> n);
   end_if;
   if iszero(n-N) then // n = N, then Random = X
         return(() -> X);
   end_if;
	

 // ------ unevaluated return ? --------
  if domtype(N)  <> DOM_INT or
     domtype(n)  <> DOM_INT or
     domtype(X)  <> DOM_INT 
  then
    if args(0) = 3 then
         return(procname(args()));
    else // do not accept any symbolic in conjunction
         // with Seed = s, because otherwise the following would
         // happen:
         // delete a, b: f:= stats::XXXRandom(a, b, Seed = 1):
         // a:= 1: b:= 2: f(), f(), f()
         //     -1.506518279, -1.506518279, -1.506518279
         error("all parameters must be numerical ".
               "if 'Seed = ...' is specified"):
    end_if;
  end_if:

   // if still any is symbolic nothing can be said
   if domtype(N) <> DOM_INT or
      domtype(X) <> DOM_INT or
      domtype(n) <> DOM_INT then
         return(procname(args()));
   end_if;


  //-------------------------------
  // return the following procedure
  // according to George S. Fishman "Monte Carlo", 1996 Springer, 
  // p. 218 - 221, algorithm HYP for miu <= 3, 
  // algorithm HRUA* for miu > 3
  //-------------------------------
  proc()
  local a, b, i, Y, miu, tmp;
  begin
	b := min(X, N-X);
	miu := b * n/N;
//	if miu <= 3 then 

// --------------------------- algorithm HYP -------------------------
// without loss of generality assume b = X
// we're n times randomly picking one element out of those N elements
// first picking: Y = X success elements, probability to pick one success
// = Y/N, that random experiment can be simulated with
// "got one", if rand() <= Y/N, "got none" else
// since 1 - rand() has same probability as rand(), we have
// "got one" <=> 1 - rand() <= Y/N
// thus we have Y = Y - trunc(rand() + Y/N) success elements left
// 2nd picking: pick out of N-1 elements, check for a success
//  ....
// finally Y success elements are left, 
// we have thus picked X - Y success elements
//
// yet behold before ye start:
// // chances are rather slim that in case X < n in the while loop
// Y = 0, i.e. after less than n iterations (even for n iterations) 
// all of the X sucess elements have been picked.

// if X < n it is wise to interchange 'em both as for the cumulative
// probabiltiy holds P(N,X,n)(x) = P(N,n,X)(x).
// 
// --------------------------------------------------------------------
		if n > X then // interchanging X and n
			tmp := X;	
			X   := n;
			n   := tmp;
		end_if;

        	a := N - n;
	   	Y := b;
		i := n;

		while (Y * i) > 0 do
			Y := Y - trunc(rand() + Y/(a + i));
			i := i - 1;
		end_while;

		Y := b - Y ;
		if X <= N - X then return(Y);
		else return(n - Y) end_if;		
//	else		

// -------------------------- algorithm HRUA* ----------------------
// not yet implemented as it does not seem to ba straightforwardly 
// clear how much faster it is than HYP
// -------------------------------------------------------------------
//		a := min(N-n,n);
//	end_if;
   end_proc

end_proc:
