//       

/*--
Call(s): a_quantile(a, l) 
         a_quantile(a, s, c)

alpha-quantil
--*/
/*--
parameters:
a  alpha, 0 < a < 1
l  list or sequence
s  stats::sample
c  data-column index (optional if sample contains only one data-column)
--*/

stats::a_quantile := proc(a)
  local l, k;
begin
  if testargs() then
    if args(0) < 2 then
      error("Wrong number of arguments");
    end_if;
    if not(testtype(a, DOM_RAT) or testtype(a, DOM_FLOAT)) then
      error("First parameter must be of type DOM_FLOAT or DOM_RAT");
    end_if;
    if not(a > 0 and a < 1) then
      error("First parameter must be > 0 and < 1");
    end_if
  end_if;
  l:=stats::getdata(testargs(), "numeric_only", 1, args(2..args(0)));
  if testargs() then
    if domtype(l) = DOM_STRING then error(l) end_if
  end_if;

  // calculation 
  if l = [] then
    FAIL
  else
    // getdata may return complex data!
    if testargs() then
       if has(map(l, testtype, Type::Real), FALSE) then
          error("Data must be real");
       end_if:
    end_if:
    l:=sort(l);
    k:=trunc(nops(l) * a);
    if not (float(k) = float(nops(l) * a)) then
        l[ceil(nops(l) * a)]      // nops(l) * a no integer  
      else
        (l[k] + l[k + 1]) / 2     // k = nops(l) * a integer 
    end_if
  end_if
end_proc:


// end of file 
 
