//       

/*--
usage:
calc(s, c, cal1, cal2, ...)

generates new column(s) by using function(s) (_plus, fun(), mean, ...)
on elements of specified data-columns. the resulting column(s) is/are
appended to the sample.
--*/
/*--
parameters:
s    stats::sample
c    column index (integer or list), range-indices allowed
cal1 function (all further functions are optional)
--*/

stats::calc := proc(sa, co, cal)
  local s, c;
begin
  // test arguments 
  if testargs() then
    if args(0) < 3 then
      error("Wrong number of arguments")
    end_if;
    if domtype(sa) <> stats::sample then
      error("stats::sample expected")
    end_if;
    if has(map([args(3..args(0))], proc() begin bool(// tests sequence of functions 
                             testtype(args(1), DOM_FUNC_ENV) or
                             testtype(args(1), DOM_PROC) or 
                             testtype(args(1), "_fconcat")
                            ) end_proc ), FALSE)
    then   
      error("Function or type DOM_FUNC_ENV or DOM_PROC expected")
    end_if;
    if not testtype(co, DOM_LIST) then co:=[co] end_if;
    if has(map(co, proc() begin bool(testtype(args(1), DOM_INT) 
                           and 0 < args(1) and args(1) <= nops(op(sa, 1))
                           ) end_proc ), FALSE)
       or has(map(co, proc() begin not testtype(op(sa, [1, args(1)]), DOM_STRING)
                            end_proc ), FALSE)
             // if at least one element of c (column index) not of DOM_INT 
             // or < 1 or > number of columns or column contains a string  
             // the latter must be tested seperately.                      
    then   
      error("Invalid data-column index") 
    end_if
  end_if;
  s:=sa; c:=co;
  // transform ranges to sequence 
  if not testtype(c, DOM_LIST) then c:=[c] end_if;
  c:=map(c, proc() begin (if type(args(1)) = "_range" then
                    $ args(1);
                  else
                    args(1)
                  end_if) end_proc );

  // actual procedure 
  s:=(stats::sample)::convert_to(s, DOM_LIST); // sample to list 
  s:=map(s, proc() local n; begin append(args(1), cal(op(([] ;(
           for n in c do
             append(last(1), op(args(1), n)) // fills up op([])            
           end_for))))) end_proc );
  if args(0) > 3 then // iterative call of calc if more functions specified
    stats::calc(new(stats::sample, s), c, args(4..args(0)))
  else
    new(stats::sample, s)  // list to sample 
  end_if
end_proc:


// end of file 
 


