/*
  Compute the Chi square function P(x)


f(u,v) = (u^(v/2-1)*exp(-u/2))/(gamma(v/2)*(2^(v/2)))

          v integer, v > 0 

P(x) = int(f(u,v), u = 0..x)
     = int(u^(v/2-1)*exp(-u/2),u = 0..x)/(gamma(v/2)*(2^(v/2)))
     = ( F(x)-F(0) ) / (gamma(v/2)*(2^(v/2)))

     F(u) = int(u^(v/2-1)*exp(-u/2),u)  , see (1)

P(x) = int(f(u), u = 0..x) 
     = 2*x/v * f(x) * (1+sum(x^k / ( (v+2)*...*(v+2*k) ), k=1..infinity)

     see (4)
*/

stats::ChiSquare := proc(x, v) // x >= 0, v > 0 , x real, v integer 
  local F, _P_, l, k, m, n, r, s, u;
begin
   if args(0) <> 2 then
      error("Two arguments expected")
   end_if;

  case type(x)
    of DOM_SET do
    of "_union" do
      return(map(x, stats::ChiSquare, v))
  end_case;

  u:= genident();                     
  r := sqrt(2*PI)*erf(sqrt(2*u)/2);
  if domtype(x) = DOM_FLOAT then
     r := float(r)
  end_if;
  if v = 1 then
     F := r
  else
     if domtype(v) <> DOM_INT or v<1 then
        error("the second argument must be a positive integer")
     end_if;
     n := v/2-1; 
     m := trunc(n);
     s := _plus(2^(k+1)*u^(n-k)*_mult(n-l+1 $ l=1..k) $ k=0..m);
     F := -exp(-u/2) * s;
     if v mod 2 = 1 then
        F := F + 2^m * _mult(n-l+1 $ l=1..m) * r;
     end_if;
  end_if;
  _P_ := (subs(F, u=x,EvalChanges) - subs(F, u=0, EvalChanges)) / (gamma(v/2)*(2^(v/2)));
  if domtype(x) = DOM_FLOAT then _P_:= float(_P_) end_if:
  return(_P_);
end_proc:

/*-------------------------------------------------------------

(1) F(u) = int(u^n*exp(-u/2), u)    
   
            +- r                       v = 1 , m = 0
         = -+  -exp(-u/2) * s ,        v even, m = n
            +- -exp(-u/2) * s + p * r, v > 1 odd , m = trunc(n)
	  
   
   n = v/2-1

   s = _plus(2^(k+1)*u^(n-k)*_mult(n-l+1 $ l=1..k) $ k=0..m)
   
   p  = 2^m * _mult(n-l+1 $ l=1..m) = 
   
   r  = sqrt(2*PI)*erf(sqrt(2*u)/2)
   
           +- 2^(m+1)*_mult(n-l+1 $ l=1..m) , v even
   F(0) = -+
           +- 0                             , v odd

(2) int(u^n*exp(-u/2), u)
       (3)
        = u^n * (-2)*exp(-u/2) - int(n*u^(n-1) * (-2)*exp(-u/2), u)
   
        = -2*u^n*exp(-u/2) + 2*n * int(u^(n-1)*exp(-u/2),u)
   
     int(u^0*exp(-u/2), u)      = -2*exp(-u/2)

     int(u^(-1/2)*exp(-u/2), u) = sqrt(2*PI)*erf(sqrt(2*u)/2)

(3) int(f(u)*g(u), u) = f(u)*g(u) - int(f(u)*g(u), u)

(4) 

P(x) := proc(x, v)
   local eps, f, pvk, s, t, xk, v2, vk;
begin
   v2 := v/2; 
   f  := x^(v2-1) / ( 2^v2 * gamma(v2) * exp(x/2) );
   
   xk := x; vk := v+2; pvk := vk; s := 0; eps := 10^(-DIGITS);
   repeat 
      t := xk/pvk;
	  s := s+t;
	  xk := xk*x; vk := vk+2; pvk := pvk*vk;
   until t < eps end_repeat;
   
   2*x/v*f*(1+s)
   
end_proc:
-------------------------------------------------------------*/
