/* 
  Literatur: 
  Bronstein, Semendjajew; Taschenbuch der Mathematik;
  Kapitel 5, S. 663 ff
*/ 

/*
  Dichte der Normalverteilung 
  mit den Verteilungsparametern a und v
*/
stats::N := proc(y, a, v) 
  begin exp(-1/2 * (y-a)^2 / v^2) / sqrt(2*PI*v) end_proc:

/* 
  Dichte der x^2-Verteilung (Chi-Quadrat-Verteilung)
  mit dem Freiheitsgrad v > 0
*/
stats::C := proc(y, v)
  begin y^(v/2-1)/2^(v/2)/gamma(v/2)/exp(y/2) end_proc:
  
/* 
  Dichte der t-Verteilung (Student-Verteilung) 
  mit dem Freiheitsgrad n
*/
stats::t := proc(y, n)
  begin 
    gamma((n+1)/2)/gamma(n/2)/sqrt(PI*n)*(1+y^2/n)^(-(n+1)/2) 
end_proc:
 
/* 
  Dichte der Exponentialverteilung
  mit dem Verteilungsparameter lambda > 0
*/
stats::Exp := proc(y, lambda)
  begin stats::W(y, 1, lambda) end_proc:

/* 
  Dichte der Weibull-Verteilung
  mit den Verteilungsparametern p >= 0 und g > 0
*/ 
stats::W := proc(y, p, g)
  begin
    if y < 0 then
	   0
	else
	   g*p*y^(p-1)*exp(-g*y^p)
	end_if
end_proc:

/* 
  Dichte der Snedecorschen F-Verteilung
  mit den Freiheitsgraden n und m
*/ 
stats::F := proc(y, n, m)
  begin 
     ( gamma((n+m)/2)*y^(n/2-1)*(n/m)^(n/2) ) / 
	 ( gamma(n/2)*gamma(m/2)*(1+n/m*y)^((n+m)/2) )
end_proc:

/* 
  Dichte der Fisherschen Z-Verteilung
  mit den Freiheitsgraden n und m
*/ 
stats::Z := proc(y, n, m)
  begin ln(sqrt(stats::F(y, n, m))) end_proc:
  
/*
  Dichte der Poissonverteilung
  mit dem Verteilungsparameter lambda > 0 
*/
stats::P := proc(y, lambda) // lambda > 0 reell, y >= 0 ganzzahlig 
  begin lambda^y/fact(y)*exp(-lambda) end_proc:

/*
  Dichte der hypergeometrischen Verteilung
  mit den Verteilungsparametern n, m und k 
  (n, m ganzzahlig > 0 und k aus 1..n+m)
*/  
stats::H := proc(y, n, m, k) // y aus 0..k 
  begin binomial(n, y)*binomial(m,k-y)/binomial(n+m,k) end_proc:

