//       

/*--
usage:
geometric(l) / geometric(s, c)

geometric mean value
--*/
/*--
parameters:
l  list or sequence
s  stats::sample
c  data-column index (optional if sample contains only one data-column)
--*/

stats::geometricMean := proc()
  local l;
begin
  l:=stats::getdata(testargs(), "all_data", 1, args());
  if testargs() then
    if domtype(l) = DOM_STRING then error(l) end_if
  end_if;

  // calculation 
  if l = [] or ( has(map(l, sign), -1) and has(map(l, sign), 1) ) then
    FAIL // division by zero or unsensible use of geometric 
  else
    _mult(op(l))^(1/nops(l))
  end_if
end_proc:

// end of file 
 
