//       

/*--
usage:
median(l) / median(s, c)

median value, 0.5-quantile
--*/
/*--
parameters:
l  list or sequence
s  stats::sample
c  data-column index (optional if sample contains only one data-column)
--*/

stats::median := funcenv(proc()
begin
  if has([args()], Averaged) then
     stats::empiricalQuantile(subs(args(), Averaged = null()))(1/2, Averaged);
  else
     stats::empiricalQuantile(args())(1/2);
  end_if;
end_proc):
stats::median::Content := stdlib::genOutFunc("Cmedian", 1, infinity):

// end of file 
 
