/*
  Normal distribution

I(u, m, v) = int(exp(-(u-m)^2/(2*v))/sqrt(2*PI*v),u) 
           = 1/2*erf(1/2*sqrt(2)*u/sqrt(v)-1/2*sqrt(2)*m/sqrt(v))
           = 1/2 erf(1/2*sqrt(2)*(u-m)/sqrt(v))

I(u) = I(u, 0, 1) = int(exp(-1/2*u^2)/sqrt(2*PI),u)
                  = 1/2*erf(1/2*sqrt(2)*u)

limit(I(u, m, v), u=-infinity) = -1/2

normal(x, m, v) = int(exp(-(u-m)^2)/(2*v))/sqrt(2*PI*v),u=-infinity..x)
                = I(x, m, v) + 1/2
normal(x, m) = normal(x, m, 1)
normal(x) = normal(x, 0, 1) ;

*/

stats::normal := proc(x, m, v)   
   local w;
begin

   case type(x)
     of DOM_SET do
     of "_union" do
       return(map(x, stats::normal, args(2..args(0))))
   end_case;

  case args(0)
    of 1 do w := x; break;
    of 2 do w := x-m; break;
    of 3 do w := (x-m)/sqrt(v); break;
    otherwise error("wrong no of args")
  end_case;

  if domtype(x) = DOM_FLOAT then
     1/2*erfc(-float(w/sqrt(2)));
  else 
     1/2*erfc(-w/sqrt(2));
  end_if
end_proc:
