//       

/*--
usage:
obliquity(l) / obliquity(s, c)

obliquity of given distribution
returns zero if symmetric
--*/
/*--
parameters:
l  list or sequence
s  stats::sample
c  data-column index (optional if sample contains only one data-column)
--*/

stats::obliquity := proc()
  local l, x_, g;
begin
  l:=stats::getdata(testargs(), "all_data", 1, args());
  if testargs() then
    if domtype(l) = DOM_STRING then error(l) end_if
  end_if;

  // calculation 
  if l = [] then
    FAIL // division by zero 
  else
    x_:=_plus(op(l))/nops(l);
    g:=_plus(op(map(map(l, _plus, -x_), _power, 2)));
    if iszero(g) then
      FAIL // division by zero 
    else
      nops(l)^(1/2)*_plus(op(map(map(l, _plus, -x_), _power, 3)))/(g^(3/2))
    end_if
  end_if
end_proc:


// end of file 
 
