//       

/*--
usage:
quadraticMean(l) / quadraticMean(s, c)

quadratic mean value (root-mean-square)
--*/
/*--
parameters:
l  list or sequence
s  stats::sample
c  data-column index (optional if sample contains only one data-column)
--*/

stats::quadraticMean := funcenv(proc()
  local l;
begin
  l:=stats::getdata(testargs(), "all_data", 1, args());
  if testargs() then
    if domtype(l) = DOM_STRING then error(l) end_if
  end_if;

  // calculation 
  if l = [] then
    FAIL // division by zero 
  else
    sqrt(_plus(op(map(l, _power, 2)))/nops(l))
  end_if
end_proc):
stats::quadraticMean::Content := (Out, x) -> if nops(x) = 0 then
                                               Out::stdFunc(x)
                                             else
                                               Out::Capply(Out::CquadraticMean,
                                                           Out(op(x))):
                                             end_if:


// end of file 
 
