//       

/*--
usage:
stdev(l) / stdev(s, c) /
stdev(l, Sample) / stdev(s, c, Sample) 

standard deviation ( sqrt(1/n*(...)) or sqrt(1/(n-1)*(...)) 
                     if option Sample is selected           )
--*/
/*--
parameters:
l           --  list or sequence
s           --  stats::sample
c           --  data-column index (optional if sample contains only one data-column)
mode        -- either Sample or Population. 
               Until Release 2.1 the default used to be Population,
               from Release 2.1, the default is Sample

--*/

stats::stdev := funcenv(proc()
  local data, X, smple, n;
begin
  if args(args(0)) = Sample then
    smple:= 1;
    data:=stats::getdata(testargs(), "all_data", 1, args(1..(args(0)-1)));
  elif args(args(0)) = Population then
    smple:=0;
    data:=stats::getdata(testargs(), "all_data", 1, args(1..(args(0)-1)));
  else
    smple:= 1;
    data:=stats::getdata(testargs(), "all_data", 1, args());
  end_if;

  // pass error messages from stats:;getdata to the caller
  // of stats::stdev:
  if domtype(data) = DOM_STRING then error(data) end_if;

  // calculation 
  n:=nops(data);
  if iszero(n - smple) then
    return(FAIL); // else division by zero 
  else
    X:= _plus(op(data))/n;
    return(sqrt(_plus(op(map(map(data, _subtract, X), _power, 2)))/(n - smple)));
  end_if;
end_proc):
stats::stdev::Content := stdlib::genOutFunc("Csdev", 1, infinity):


// end of file 
 
