//       

/*--
usage:
variance(x1,x2,..., <mode>)
variance([x1,x2,..], <mode>)
variance(sample, <colindex>, <mode>)
--*/
/*--
parameters:
x1, x2, ... -- data (arithmetical expressions)
s           -- sample of type stats::sample
c           -- integer representing a column index of s
               (optional if sample contains only one data-column)
mode        -- either Sample or Population. 
               Until Release 2.1 the default used to be Population,
               from Release 2.1, the default is Sample
--*/

stats::variance := funcenv(proc()
local data, X, smple, n;
begin
  if args(args(0)) = Sample then
    smple:= 1;
    data:=stats::getdata(testargs(), "all_data", 1, args(1..(args(0)-1)));
  elif args(args(0)) = Population then
    smple:=0;
    data:=stats::getdata(testargs(), "all_data", 1, args(1..(args(0)-1)));
  else
    smple:= 1;
    data:=stats::getdata(testargs(), "all_data", 1, args());
  end_if;

  if domtype(data) = DOM_STRING then
      error(data);
  end_if;

  // calculation 
  n:= nops(data);
  if iszero(n - smple) then
    return(FAIL); // division by zero 
  else
    X:= _plus(op(data))/n;
    return(_plus(op(map(map(data, _subtract, X), _power, 2)))/(n - smple));
  end_if;
end_proc):

stats::variance::Content := stdlib::genOutFunc("Cvariance", 1, infinity):

// end of file 
 
