//       

/*--
usage:
zipCol(l1, l2, ...)

the input-lists' elements are gathered in sub-lists according to their
element index. these sub-lists form the resulting list.
--*/
/*--
parameters:
l1 list (all further lists are optional)
--*/

stats::zipCol:=proc(l1, l2)
begin
  if testargs() then
    if args(0) < 1 then
      error("Wrong number of arguments")
    end_if;
    if has(map([args(1..args(0))], proc() begin bool(domtype(args(1)) = DOM_LIST
                                           ) end_proc ), FALSE)
    then
      error("All arguments must be of type DOM_LIST")
    end_if
  end_if;
  if args(0) = 1 then
    return(map(l1, proc() begin [args(1)] end_proc ))
  end_if;
  zip(map(l1, proc() begin (if domtype(args(1)) <> DOM_LIST then 
                          [args(1)]
                        else
                          args(1)
                        end_if) end_proc ),
                        l2, append);
  if args(0) > 2 then
    stats::zipCol(last(1), args(3..args(0)))
  else
    return(last(1))
  end_if
end_proc:


// end of file 
 
