

// 5^x*6^x/10^x/3^x ==> (5*6/10/3)^x ==> 1 // tonner 
combine::_power:=
proc(X, options = combine::defaultOptions)
  local a,f,s,p,x,t, k, l, base;
begin
  userinfo(5, "Attribute combine::_power called");
  if type(X)<>"_mult" then
    return(X)
  end_if;
 
  if options[IgnoreAnalyticConstraints] then
    // check whether the exponents have a non-trivial gcd 
    l:= [op(X)];
    if {op(map(l, type))} = {"_power"} then
      // get exponents
      f:= map(l, op, 2);
      // divide off the gcd of the numerators of the exponents/ gcd of the denominators of the exponents
      // but *not* the gcd of the exponents (which would be gcd of numerators / lcm of denominators)
      // e.g., we do not want to write X^2*Y^(1/2) as (X^4*Y)^(1/2)
      if not hastype(f, DOM_FLOAT) and (k:= gcd(op(map(f, numer))) / gcd(op(map(f, denom)))) <> 1 then
        // divide off the gcd in all exponents
        l:= map(l, pow -> op(pow, 1)^(normal(op(pow, 2)/k)));
        // now X = (l[1] * l[2] *...)^k, at least in the "sloppy" sense
        l:= _mult(op(l));
        // now X = l^k, in the "sloppy" sense
        if type(l) = "_mult" then 
          l:= _mult::combine(l, options)
        end_if;  
        if type(l) = "_power" then
          return(op(l, 1)^(op(l, 2)*k))
        elif stdlib::hasmsign(k) then
          return((1/l)^(-k))
        else  
          return(l^k)
        end_if   
      end_if  
    end_if;
  end_if;
  
  a:=1; // product of non-powers
  s:={}; // set of exponents
  p:=table(); // p[x] is the list of all factors being to power x
  for f in X do
    if type(f) = "_power" or type(f) = DOM_COMPLEX and op(f, 1) = 0 then
      if type(f) = DOM_COMPLEX then
        x:= 1/2;
        base:= -1;
        a:= a*f/I
      else         
        x:= op(f,2);
        base:= op(f,1)
      end_if;
      // extract integer factors from x where possible
      if type(x) = DOM_RAT and op(x, 1)<>1 and
        (options[IgnoreAnalyticConstraints] or is(base >= 0, Goal = TRUE)) 
        and combine::isSmall(base, op(x, 1))
        then
        base:= base^op(x,1);
        x:= 1/op(x,2)
      elif type(x) = "_mult" and type((t:= op(x, nops(x)))) = DOM_INT
        and (options[IgnoreAnalyticConstraints] or is(base>=0, Goal = TRUE)) 
        and combine::isSmall(base, t) then 
        base:= base^t;
        x:= x/t
      end_if;
      if not contains(s,x) then
        if not contains(s,-x) or
          /* second case: a^(-x)=(1/a)^x does not hold e.g.
             when a=-1, x=1/2
          */
          not options[IgnoreAnalyticConstraints] and
          (not is(x in Z_, Goal = TRUE) or
           not is(base > 0, Goal = TRUE)) then
          p[x]:=[base]; s:=s union {x}
        else
          p[-x]:=p[-x] . [1/base]
        end_if
      else
        p[x]:=p[x] . [base]
      end_if
    else
      a:=a*f
    end_if
  end_for;
  userinfo(10, "Table of powers (by exponent): ",p);
  for f in s do
    l:= p[f]; // list of all bases belonging to exponent f
	 // x>0 or y>0  =>  x^b * y^b = (x*y)^b 
	 // Re(x)>0 or (Re(x)=0 and Im(y)>0)  =>  x^b * y^b = (x*y)^b
    if not options[IgnoreAnalyticConstraints] then
      t:= map(l,
      proc(y)
      begin
        if testtype(y,Type::Numeric) then
          bool(sign(y)=1)
        else
          is(y>0)
        end_if
      end_proc)
    else
      t:= map(l,
      proc(y)
      begin 
        bool(numeric::isless(y, 0) <> TRUE)
      end_proc)
    end_if;
	 // x>0 or y>0  =>  x^b * y^b = (x*y)^b 
    if nops(select(t,_equal,TRUE)) + 1 >= nops(t) then
      // at most one operand is not positive: we may combine all
      
      if options[IgnoreAnalyticConstraints] or is(f in Z_, Goal = TRUE) then
        // first take care to distribute products like x^2*y^2
        l:= map(l, bas -> if type(bas) = "_mult" then op(bas) else bas end_if);
        if {op(map(l, type))} = {"_power"} then
          // (x^4*y^2)^n -> (x^2*y)^(2*n) and similar cases
          t:= map(l, op, 2); // exponents
          if traperror((k:= map(t, icontent))) <> 0 or map({op(k)}, domtype) <> {DOM_INT} then
            // no common factor can be found
            k:= 1
          else  
            k:= igcd(op(k)) // igcd of exponents
          end_if;  
          if k<>1 then
            // move the factor k from the individual exponents of the factors into the common exponent
            f:= f*k;
            l:= map(l, pow -> op(pow, 1)^(op(pow, 2)/k))
          end_if
        end_if;
      end_if;  
      
      t:= _mult( op(l) );
      if iszero(t) or length(t^f)<=length((1/t)^(-f)) or
        (is(f, Type::Integer) or is(t > 0)) <> TRUE then
        if type(t) = "_power" and 
          (options[IgnoreAnalyticConstraints] or 
          is(op(t, 1) > 0, Goal = TRUE) and 
          (is(f in Z_, Goal = TRUE) or is(op(t, 2) in Z_, Goal =TRUE))
          )  then
          a:= a*op(t, 1)^(f*op(t, 2))
        else
          a:=a*t^f
        end_if  
      else
        a:=a*(1/t)^(-f)
      end_if
    else
            /* Re(x)>0 or (Re(x)=0 and Im(x)>0)  AND
	      Re(y)>0 or (Re(y)=0 and Im(y)>0)      =>  x^b * y^b = (x*y)^b 
	    */ 
      t:= select(l,
                 proc()
                 begin
                   (testtype(args(1),Type::Numeric) and
                    (sign(Re(args(1)))=1
                     or sign(Re(args(1)))=0 and sign(Im(args(1)))=1))
                   or (is(Re(args(1))>0)=TRUE or
                       (is(Re(args(1))=0) and is(Im(args(1))>0)) = TRUE)
                 end_proc  );
      if t = l then
        t:= _mult( op(l) );
        if length(t^f)<=length((1/t)^(-f)) or
          (is(f, Type::Integer) or is(t > 0)) <> TRUE then
          a:=a*t^f
        else
          a:=a*(1/t)^(-f)
        end_if
      else
        a:= _mult(a,op(map(l, _power, f)))
      end_if
    end_if
  end_for;
  a
end_proc:

// end of file
