// arctan(x)+arctan(y) = arctan((x+y)/(1-x*y)) if abs(x*y) < 1
// thus, if abs(x*y)>1 
combine::arctan:=
proc(e, options = combine::defaultOptions: DOM_TABLE)
  local s,f,x,y,n, A, v, M: DOM_DOMAIN;
begin
  case domtype(e) // default is to return e
    of DOM_POLY	  do
      return( mapcoeffs(e, combine::arctan, options) )
    of DOM_LIST    do
    of DOM_ARRAY   do
    of DOM_SET     do
      return( map(e, combine::arctan, options))
    of DOM_EXPR    do
      case type(e)
        of "_plus" do
          s:=0; 
          x:=0;
          e:= map(e, x -> if type(x) = "_mult" then
                            combine::arctan(x, options)
                          else
                            x
                          end_if);
          // Beware: PI - 2*arctan(x) may have been combined 
          // to arctan(2*x/(x^2 - 1)) and there is no sum
          // anymore. In this case, return here:
          if type(e) <> "_plus" then
             return(combine::arctan(e, options));
          end_if;
          // process the sum e:
          for f in e do
            if type(f)="arctan" then
              y:=op(f);
              if is(abs(x*y) < 1) = TRUE then
                x:=(x+y)/(1-x*y)
              elif is(x = 1/y) = TRUE then
                s:= s+ signIm(I*x) * PI/2;
                x:= 0;
              elif is(abs(x*y) > 1) = TRUE then
/*
arctan(x) + arctan(y) = (sgn1 + sgn2)*PI/2 - arctan(1/x) - arctan(1/y)
where sgn1 = signIm(I*x), sgn2 = signIm(I*y)
since abs(1/x * 1/y) < 1, we may apply the aforementioned rule:
arctan(1/x) + arctan(1/y) = arctan((1/x + 1/y)/(1 - 1/x * 1/y))
                          = arctan((x+y)/(x*y-1))
                          = -arctan((x+y)/(1-x*y))
*/
                s:= s+ PI/2*(signIm(I*x)+signIm(I*y));
                x:=(x+y)/(1-x*y)
              else
                s:= s+f;
              end_if
            else
              s:= s+f
            end_if
          end_for;
          return(s+arctan(x))
        of "_mult" do
          if nops(e)=2 and type(op(e,1))="arctan" and
            type((n:=op(e,2)))=DOM_INT then
            if testtype((x:= op(e, [1, 1])), Type::Constant) then
            // let arctan(F(n)) := n*arctan(x)
            // then F(n) is a rational function in x, F= p/q
            // modulo PI, it satisfies the recursion formula
            // F(n+1) = (x + F(n))/(1 - xF(n))
            //        = (x + p/q) / (1 - xp/q)
            //        = (p + xq) / (-xp + q)
            // F(0)   = 0/1
            // thus [p(n), q(n)] = A^n * [0, 1] where A is the matrix
            // A = [[1, x], [-x, 1]]
            //
            // we do this for numerical x only, as we cannot find out
            // which multiple of PI we have to add otherwise 
            
              M:= Dom::Matrix(Dom::ExpressionField(normal, iszero));
              A:= M(2, 2, [[1, `#x`], [-`#x`, 1]]);
              v:= M(2, 1, [0, 1]);
              v:= A^specfunc::abs(n) * v;
              s:= hold(arctan)(subs(expr(v[1]/v[2]),
                                    `#x` = x*specfunc::sign(n)));
              f:= round((e-s)/PI);
              return(s + f*PI)
            elif n<0 then
              return(-n*hold(arctan)(-x))
            else
              return(e)
            end_if
          end_if;
          return(e)
        otherwise
          return(map(e, combine::arctan, options))
      end_case
  end_case;
  e
end_proc:

// end of file