

// cos(x)^2 -> cos(2*x)/2+1/2 
combine::sincos:=
proc(ee, options)
local l,k,f, e;
begin
   e:=ee; // to avoid warnings 
   case domtype(e) // default is to return e 
   of DOM_POLY	  do return( mapcoeffs(e, combine::sincos, options))
   of DOM_LIST    do 
   of DOM_ARRAY   do
   of DOM_SET     do return( map(e, combine::sincos , options))
   of DOM_EXPR    do
       case type(e)
         of "_mult" do e:=[op(e)]; break
         of "_power" do e:=[e]; break
         otherwise
           return(map(e, combine::sincos, options))
       end_case;
       // now deal with _mult and _power case
      k:=1; l:=[];
      for f in e do
         case type(f)
         of "sin" do
         of "cos" do l:=append(l,f); break
         of "_power" do
            if contains({"sin","cos"},type(op(f,1))) and
              testtype(op(f,2),Type::PosInt) then
              l:=append(l,op(f,1)$op(f,2)); break
            end_if
         otherwise
             k:=k*map(f, combine::sincos, options)
         end_case;
      end_for;
      return(stdlib::combine_sin_cos(l,k))
   end_case;
   e
end_proc:

// k is a scalar, l is a list of sin or cos expressions 
stdlib::combine_sin_cos :=
proc(ll,kk)
  local l, k;
begin
  l:=ll; k:=kk; // to avoid warnings
  if l=[] then return(k) end_if;
  while nops(l)>=2 do
    if type(l[1])="_plus" then
      l[1]:=map(l[1],stdlib::combine_sincos,l[2])
    else
      l[1]:=stdlib::combine_sincos(l[1],l[2])
    end_if;
    delete l[2];
  end_while;
  if type(l[1])="_plus" then map(l[1],_mult,k) else k*l[1] end_if
end_proc:

// for x*y where x and y can be cos(..) or a*cos(..) or a where a is a rational 
stdlib::combine_sincos := proc(xx,yy) 
local a,b,m, x, y;
begin
   x:=xx; y:=yy;
   if type(x)="_mult" then x:=split(x,testtype,Type::Union("cos","sin"));
	m:=x[2]; x:=x[1]; else m:=1 end_if;
   if type(y)="_mult" then y:=split(y,testtype,Type::Union("cos","sin"));
	m:=m*y[2]; y:=y[1] end_if;
   a:=op(x); b:=op(y);
   case type(x),type(y)
   of "sin","sin" do m/2*cos(a-b)-m/2*cos(a+b); break
   of "sin","cos" do
     if stdlib::hasmsign(a-b) then
       m/2*sin(a+b)-m/2*sin(b-a)
     else
       m/2*sin(a+b)+m/2*sin(a-b)
     end_if;
     break
   of "cos","sin" do
     if stdlib::hasmsign(a-b) then
       m/2*sin(a+b)+m/2*sin(b-a)
     else
       m/2*sin(a+b)-m/2*sin(a-b)
     end_if;
     break
   of "cos","cos" do m/2*cos(a-b)+m/2*cos(a+b); break
   otherwise m*x*y /* it can happen that x or y is a constant, 
			for example cos(0) -> 1 for cos(t)^3 */
   end_case
end_proc:

// end of file
