
/*
|    The following routines are used to combine expressions including
|    sinh and cosh. The algorithms are the same as in case of combining
|    expressions involving sin and cos. Therefore the above procedures
|    combine:=slot(combine,"sincos",...), sdtlib::combine_sin_cos()
|    and stdlib::combine_sincos() have been renamed to
|    combine:=slot(combine,"sincos",...), stdlib::combine_sinh_cosh
|    and stdlib::combine_sinhcosh. 
|
|    does not react to option IgnoreAnalyticConstraints
*/

combine::sinhcosh:=
proc(ee, options)
  local l,k,f,e;
begin
  e:=ee;
  case domtype(e) // default is to return e
    of DOM_POLY    do
      return( mapcoeffs(e, combine::sinhcosh, options))
    of DOM_LIST    do
    of DOM_ARRAY   do
    of DOM_SET     do
      return( map(e, combine::sinhcosh, options) )
    of DOM_EXPR    do
      case type(e)
        of "_mult" do
          e:=[op(e)];
          break
        of "_power" do
          e:=[e];
          break
        otherwise
          return(map(e, combine::sinhcosh, options))
      end_case;
      // now deal with _mult and _power case 
      k:=1; l:=[];
      for f in e do
         case type(f)
         of "sinh" do
           of "cosh" do
             l:=append(l,f);
             break
         of "_power" do
             if contains({"sinh","cosh"},type(op(f,1))) and
               testtype(op(f,2),Type::PosInt) then
               l:=append(l,op(f,1)$op(f,2));
               break
            end_if
         otherwise
             k:=k*map(f, combine::sinhcosh, options)
         end_case;
      end_for;
      return(stdlib::combine_sinh_cosh(l,k))
   end_case;
  e
end_proc:

// k is a scalar, l is a list of sinh or cosh expressions 
stdlib::combine_sinh_cosh := proc(l,k)
begin
   if l=[] then return(k) end_if;
   while nops(l)>=2 do
      if type(l[1])="_plus" then
         l[1]:=map(l[1],stdlib::combine_sinhcosh,l[2])
      else l[1]:=stdlib::combine_sinhcosh(l[1],l[2])
      end_if;
      delete l[2];
   end_while;
   if type(l[1])="_plus" then map(l[1],_mult,k) else k*l[1] end_if
end_proc:

// for x*y where x and y can be cos(..) or a*cos(..) or a where a is a rational 
stdlib::combine_sinhcosh := proc(xx,yy)
local a,b,m, x, y;
begin
   x:=xx; y:=yy;
   if type(x)="_mult" then
        m:=op(x,2);
        x:=op(x,1):
   else
        m:=1
   end_if;
   if type(y)="_mult" then
       m:=m*op(y,2);
       y:=op(y,1):
   end_if;
   a:=op(x); b:=op(y);
   case type(x),type(y)
   of "sinh","sinh" do -m/2*cosh(a-b)+m/2*cosh(a+b); break
   of "sinh","cosh" do m/2*sinh(a+b)+m/2*sinh(a-b); break
   of "cosh","sinh" do
        if stdlib::hasmsign(a-b) then
            m/2*sinh(a+b)+m/2*sinh(b-a);
        else
            m/2*sinh(a+b)-m/2*sinh(a-b);
        end_if:
   break
   of "cosh","cosh" do m/2*cosh(a-b)+m/2*cosh(a+b); break
   otherwise m*x*y /* it can happen that x or y is a constant,
                        for example cos(0) -> 1 for cos(t)^3 */
   end_case:
end_proc:

// end of file
