
/*
   combine::combineExponents(e, options)

   e - product
   options - table

   applies the rule x^a * x^b -> x^(a+b) to the product e

*/

combine::combineExponents:=
proc(e: "_mult", options)
local i: DOM_INT, j: DOM_INT, l, f, gcdfunc, sgn, base, expo, bases, expos,
retainBasej, retainBase
;
begin
 
  
  // retainBasej
  // given that we try to combine [base, expo] with [bases[j], expos[j]]
  // and know that base = -bases[j], express 
  // base^expo as bases[j]^expo * (-1)^expo
  // thus eliminating base from the list of bases
  retainBasej:= 
  proc()
  begin
    sgn:= sgn*(-1)^expo;
    expos[j]:= expos[j] + expo;
    base:= 1;
    expo:= 1
  end_proc;
   
  // retainBasej
  // given that we try to combine [base, expo] with [bases[j], expos[j]]
  // and know that base = -bases[j], express 
  // bases[j]^expos[j] as base^expos[j] * (-1)^expos[j]
  // thus eliminating bases[j] from the list of bases
  
  retainBase:=
  proc()
  begin
     bases[j]:= base;
     sgn:= sgn*(-1)^expos[j];
     expos[j]:= expos[j] + expo;
     base:= 1;
     expo:= 1
  end_proc;	
   
  e:= map(e, X -> if type(X) = "_power" and op(X, 1) = 0 then Simplify::zeroPower(X) else X end_if);
  if type(e) <> "_mult" then return(e) end_if;
     
  sgn:= 1;
  f:= [op(e)];
  bases := map(f,
    fi -> if type(fi) = "_power" then
            [op(fi)]
          else
            [fi, 1]
          end);
  expos := map(bases, op, 2);
  bases := map(bases, op, 1);
  
  for i from 1 to nops(f) do
    base := bases[i];
    expo := expos[i];
    if (j:= contains(bases, -base)) > 0 then
      // the i-th factor is base^expo_i, the j-th factor is (-base)^expo_j
      // in general, we are not allowed to combine them, but do so for integer
      // exponents, or for option IgnoreAnalyticConstraints
      
      if options[IgnoreAnalyticConstraints] then 
        // we want to retain the base with positive sign!
        if stdlib::hasmsign(base) then
          retainBasej()
        else
          retainBase()
        end_if  
      elif  type(expo) = DOM_INT then
        retainBasej()  
      elif type(expos[j]) = DOM_INT then
        retainBase()
      // else: cannot combine a^b*(-a)^c for general a, b, c!
      end_if
    end_if;
    bases[i] := base;
    expos[i] := expo;
  end_for;
  f := zip(bases, expos, (b, e) -> [b, e]);

  // we may have introduced some factors 1^1 
  // we may also have introduced factors a^0
  // remove them
  f:= select(f, l -> l[1]<> 1 and l[2]<>0 );

  
  // f = [[base1, expo1], [base2, expo2], ...]
  // flatten inner lists
  f:= map(f, op);
  
  // now f is a list suitable for polylib::refineFactorization
  gcdfunc:=
  proc(x,y)
  begin
    if x=y then
      x
    elif type(x) = DOM_INT and type(y) = DOM_INT then
      igcd(x, y)
    else
      1
    end_if
  end_proc;

  assert(contains(f, 0) = 0);
  l:= polylib::refineFactorization(f, gcdfunc);
  sgn*_mult(l[2*i-1]^l[2*i] $i=1..nops(l) div 2)

end_proc:



//end of file