/*--
        Ei/expand -- the function attribut "expand" for Ei

        implements the following rules for
        arbitrary m and n of Type::PosInt:

1) Ei(m, x) = (-x)^n*pochhammer(m, n)*Ei(m + n, x)
              - exp(-x)*_plus(pochhammer(m, k)*(-x)^(-k-1) $ k = 0 .. n-1)
   if n is a positive integer

2) Ei(m, x) = x^n/pochhammer(1-m, n)*Ei(m - n, x)
              - exp(-x)*_plus(x^k/pochhammer(1-m, k+1) $ k = 0 .. n-1)
   if n is a positive integer

--*/

Ei::expand := prog::remember(
proc(f)
   local m, x, k, n, ph;
   name Ei::expand;
begin
  // f = Ei(m, x)
  if nops(f) = 1 then
     return(Ei(expand(op(f, 1))));
  end_if:
  if nops(f) = 2 then
     m:= expand(op(f, 1)):
     x:= expand(op(f, 2));
     if type(m) = "_plus" or 
       testtype(m, Type::Numeric) then 
       if type(m) = "_plus" then
          n := select(m, testtype, Type::Numeric);
       else
          n := m;
       end_if;
       n := floor(Re(n));
       if iszero(m - n) then
         n:= n - 1;
       end_if;
       ph:= (m, n) -> _mult((m + k) $ k = 0..n-1):
       if n = 0 then
         return(Ei(m, x)):
       elif n < 0 then
         return( (-1)^n*x^n*ph(m, -n)*Ei(m - n, x)
                +_plus(exp(-x)*ph(m, k)*(-1)^k*x^(-k-1) $ k = 0..-n-1)
               );
       else
         return( x^n/ph(1 - m, n)*Ei(m - n, x)
                -_plus(exp(-x)*x^k/ ph(1 - m, k+1) $ k = 0..n-1)
               );
       end_if:
     end_if;
     return(Ei(m, x)):
  end_if;
end_proc, () -> [property::depends(args()), DIGITS]):

