/*--
	cosh/expand -- the function attribut "expand" for cosh

 cosh(-x)     = cosh(x)                                        
 cosh(x +- y) = cosh(x) * cosh(y) +- sinh(x) * sinh(y)         
                n                                              
               ---                                             
               \   (  n )                                      
 cosh(n * x) = /   ( 2*i) cosh(x)^(n-2*i)*sinh(x)^(2*i)*(-1)^i 
               ---                                             
               i=0                                             
--*/

cosh::expand:=prog::remember(
proc(a: "cosh")
  local n, t, y, i, iminus1, iminus2, coshi;
  name cosh::expand;
begin
  y := expand(op(a, 1), args(2..args(0)));

  case type(y)
       
    of "_plus" do

      n := op(y, 1);
      y := subsop(y, 1=null());
      return(expand(cosh(n)*cosh(y)+sinh(n)*sinh(y), args(2..args(0))));

    of "_mult" do

      n := op(y, nops(y));
      t := type(n);

      if t = DOM_COMPLEX and iszero(op(n, 1)) then
        return(expand(cos(y/I), args(2..args(0))))
      end_if;
       
      if t = DOM_INT or t = DOM_RAT then
        if n < 0 then
          return(expand(cosh(-y), args(2..args(0))))
        elif t = DOM_INT and n > 0 then
          y := y / n;
          iminus2:= 1; // = cosh(0*y)
          iminus1:= cosh(y);
          for i from 2 to n do
            coshi:= expand(2*iminus1 * cosh(y) - iminus2,
                           hold(sinh)(y), hold(cosh)(y), args(2..args(0)));
            iminus2:= iminus1;
            iminus1:= coshi
          end_for;
          return(coshi)
          //return(expand(2*cosh((n-1)*y)*cosh(y)-cosh((n-2)*y)));
        end_if
      end_if
  end_case;
  cosh(y)
end_proc, () -> [property::depends(args()), DIGITS]):


// end of file 
