coth::expand:= prog::remember(
proc(a: "coth")
  local y, n, t, i: DOM_INT, u, S;
  name coth::expand;
begin
  y:= expand(op(a, 1), args(2..args(0)));

  case type(y)
    of "_plus" do
      // coth(x1 + x2 + ...) = I*cot(I*(x1 + x2 + ...)) 
      return(normal(I* cot::expand(hold(cot)(y*I), args(2..args(0)))))
    of "_mult" do
      n := op(y, nops(y));
      t := domtype(n);
      // first apply I*cot(-x) = coth(I*x)
      if t = DOM_COMPLEX and iszero(op(n, 1)) then
        return(I* expand(cot(-y/I), args(2..args(0))))
      end_if;

      if indets(y, All) minus Type::ConstantIdents minus
        {hold(_plus), hold(_power), hold(_mult)}= {} then
        break;
      end_if;
      
      if t = DOM_INT then
        if n < 0 then
          return(expand(-coth(-y), args(2..args(0))))
        else // n>0
          // this is similar to cot and tanh 
          u:= coth(y/n);
          S:= u;
          for i from 2 to n do
            // we have S = coth((i-1)*y/n) and u = coth(y/n)
            // compute S:= coth(i*y/n) by using the addition formula
            // We must *not* use normal directly because this would
            // produce too many hastype - calls 
            S:= _divide(op(stdlib::normal((u*S+ 1)/(u+S))))
          end_for;
          return(S)  
        end_if
      end_if
  end_case;
  coth(y)
end_proc, () -> [property::depends(args()), DIGITS]):
