/*--
	exp/expand -- the function attribut "expand" for exp

	exp(-x)        = 1/exp(x)
	exp( x + y)    = exp(x) * exp(y)
	exp(n * x)     = exp(x) ^ n   if n*x is real
	exp(x * ln(y)) = x ^ y
--*/

exp::expand:= prog::remember(
proc(a: "exp")
  local n, t, y, k;
  name exp::expand;
begin
  y := expand(op(a, 1), args(2..args(0)));
  
  case type(y)
    of "_plus" do
      return(expand(_mult(map(op(y), exp)), args(2..args(0))));
    of "_mult" do
       n := op(y, nops(y));
       t := type(n);
       if t = DOM_INT then
         return(expand(exp(y/n), args(2..args(0)))^n)
       elif t = DOM_RAT then
          // exp(x/2)=exp(x)^(1/2) is not true for x=2*I*PI for example 
         if is(y/n,Type::Real)=TRUE or contains({args(2..args(0))}, IgnoreAnalyticConstraints) then
           return(expand(exp(y/n), args(2..args(0)))^n)
         elif n < 0 then
           return(1/expand(exp(-y), args(2..args(0))))
         end_if
       else
         for k from 1 to nops(y) do
           n := op(y, k);
           if testtype(n, "ln") then
             return(op(n, 1) ^ subsop(y, k=1))
           end_if
         end_for
       end_if;
       break
     of "LambertW" do
       // y= W(z); dividing the functional equation exp(W(z))*W(z) = z
       // by W(z) shows that exp(W(z)) = z / W(z) unless W(z) = 0
       return(piecewise([y = 0, 1], [y<>0, op(y, 2) / y]))
     // of DOM_INT do // immediately undon by kernel simplifier anyway
     //   return(exp(1)^y)
   end_case;
 exp(y)
end_proc, () -> [property::depends(args()), DIGITS]):

// end of file 
