/*--
	harmonic/expand -- the function attribut "expand" for harmonic

        implements the following rules for b of Type::PosInt:

1) harmonic(x+b) = harmonic(x + frac(b))   + 1/(x+frac(b)+1) +1/(x+frac(b)+2) + .. +1/(x+b)
   harmonic(x-b) = harmonic(x + 1-frac(b)) - 1/(x+1  -frac(b)) -1/(x+1 -frac(b)-1) + .. -1/(x-b)
2) harmonic(b*x) = ln(b) + 1/b*_plus(harmonic(x - k/b) $ k = 0.. b-1);
3) harmonic( -x )= harmonic( x ) -  1/x  + PI*cot( PI*x );
   harmonic(-b*x)= harmonic(b*x) - 1/b/x + PI*cot(PI*b*x);

--*/

harmonic::expand := prog::remember(
proc(ps: "harmonic")
  local a, fa, b, r, j, furtherargs, e, fe;
  name harmonic::expand;
begin
  e:= op(ps, 1);
  if domtype(e) = DOM_INT then
     if e >= 0 then
        return(_plus(1/j $ j=1..e) );
     else
        error("singularity");
     end_if;
  end_if:
  if domtype(e) = DOM_RAT then
     if domtype(2*e) = DOM_INT then
        if e < 0 then
           return(- 2*ln(2) + 2*_plus(1/(2*j-1) $ j=1 .. (op(-e,1)) div 2));
        else
           return(- 2*ln(2) + 2*_plus(1/(2*j-1) $ j=1 .. op(e,1)+1 div 2));
        end_if;
     end_if;
     if e > 1 then
        fe:= floor(e);
        e:= e - fe;
        return(harmonic(e) + _plus(1/(e + j) $ j = 1 .. fe));
     end_if:
     if e < 0 then
        fe:= floor(e);
        e:= e - fe;
        return(harmonic(e) - _plus(1/(e + j) $ j = fe + 1 .. 0));
     end_if;
  end_if;

  furtherargs:= args(2..args(0));
  // recursively expand the argument
  e := expand(e, furtherargs);
  if iszero(e) then
     return(0);
  end_if:

  if stdlib::hasmsign(e) then
     e:= expand(-e):
     r:= -1/e + expand(PI*cot(PI*e));
  else
     r:= 0;
  end_if:
  // The result is harmonic(e) + r.
  // Split e = non-integer + integer to apply rule 1)
  if type(e) = "_plus" or testtype(e, Type::Numeric) then // rule 1
    if type(e) = "_plus" then
      a := select(e, testtype, Type::Numeric);
    else
      a := e;
    end_if;
    fa := floor(Re(a));
    e := e - fa;
    if fa >= 0 then
      r :=  r + _plus(1/(e + j) $ j = 1 .. fa)
    else // fa < 0
      r :=  r -_plus(1/(e + j) $ j = fa + 1 .. 0)
    end_if;
  end_if;
  if iszero(e) then
     return(r);
  end_if:

  // The result is still harmonic(e) + r.
  // Do a further processing of e: If e = b*x 
  // with some integer b and symbolic x, this
  // can be expanded, too:

  if type(e) = "_mult" or domtype(e/I) = DOM_INT then // rule 2
    if type(e) = "_mult" then
      b := select(e, testtype, Type::Numeric)
    else
      b := e
    end_if;
    if domtype(b/I) = DOM_INT then
      b := b/I
    elif domtype(b) <> DOM_INT then
      b := 1
    end_if;
    e := e/b;
    if b > 0 then 
      return(r + ln(b)  + 1/b*_plus(harmonic(e + j/b) $ j = 0 .. (b - 1))
                        - 1/b*_plus(1/(e + j/b) $ j = 1 .. (b - 1)));
    else // b < 0, use rule 3 harmonic(x) = harmonic(-x) + 1/x - PI*cot(PI*x);
      return(r + ln(-b) - 1/b*_plus(harmonic(e - j/b) $ j = 0 .. (-b - 1))
                        + 1/b*_plus(1/(e - j/b) $ j = 0 .. (-b - 1))
                        + expand(PI * cot(-b*e*PI), furtherargs));
    end_if;
  else
    return(harmonic(e) + r);
  end_if
end_proc, () -> [property::depends(args()), DIGITS]):

