/*--
  log/expand -- the function attribut "expand" for log

  log(b, x ^ n)  = n * log(b, x)          if x is real positive and n is real
  log(b, x * y)  = log(b, x) + log(b, y)  if x or y are real positive
  log(b, -c * x) = log(b, c) + log(b, -x)
  log(b, b ^ n)  = n                      if n is real
--*/

log::expand := prog::remember(
proc(a: "log")
  local n, t, y, b, x, opt;
  name log::expand;
begin
  opt:= args(2..args(0));
  [b, x]:= [op(a)];
  y := normal(expand(x, args(2..args(0))));
  case type(y)
    of DOM_RAT do
      return(log(b, op(y,1))
             -log(b, op(y,2)));
    of "_mult" do
      // log(b, x*y)=log(b, x)+log(b, y) is only true
      // when x or y is real positive #
      [n, t]:= [0, 1];
      for y in y do
        if contains({opt}, IgnoreAnalyticConstraints) or 
          is(y>=0)=TRUE or
          y = b or
          (type(y) = "_power" and
           op(y,1) = b and
           is(op(y, 2), Type::Real) = TRUE
           )
          then
          n:=n+expand(log(b,y), args(2..args(0)))
        else
          t:=t*y
        end_if
      end_for;
      if n<>0 then
        return(n + expand(log(b,t), args(2..args(0))))
      else
        return(log(b,t));
      end_if;
    of "_power" do 
        // y = n^t
      n:=op(y,1);
      t:=op(y,2);
      if contains({opt}, IgnoreAnalyticConstraints) or 
        is(t in R_, Goal = TRUE) then
        if n = b then
          return(t)
        end_if;
        if contains({opt}, IgnoreAnalyticConstraints) or
	  is(n>=0)=TRUE then
          return(expand(t * log(b,n), args(2..args(0))))
        end_if;
      end_if;
      break
  end_case;

  if y=x then
    return(hold(log)(b, y))
  else
    return(log(b, y))
  end_if;
end_proc, () -> [property::depends(args()), DIGITS]):
