/*--
	psi/expand -- the function attribut "expand" for psi

        implements the following rules for
        a of Type::Real and b of Type::PosInt:

0) psi(b, n) = psi(1, n) + (-1)^n*n!*(1 + 2^(-n-1) + ... + (b-1)^(-n-1))

1) psi(x + a, n) = psi(x + frac(a), n) + (-1)^n*n!*
                    ((x + frac(a))^(-n-1) +...+ (x + a - 1)^(-n-1)) if a > 0,
   psi(x + a, n) = psi(x + frac(a), n) - (-1)^n*n!*
                    ((x + frac(a) - 1)^(-n-1) +...+ (x + a)^(-n-1)) if a < 0,
   (also for x = 0 or x of Type::Imaginary)
   
2) psi(b*x)    = ln(b) + (psi(x)    + ... + psi(x + (b - 1)/b))/b
   psi(b*x, n) = (psi(x, n) + ... + psi(x + (b - 1)/b, n))b^(n+1) if n > 0
   (also for x = I)

3) psi(-x)    =           psi(x)    + 1/x               + PI*cot(PI*x)
   psi(-x, n) = (-1)^n * (psi(x, n) + (-1)^n*n!/x^(n+1)
                          + PI^(n+1)*D([1 $ n], cot)(PI*x))
--*/

psi::expand := prog::remember(
proc(ps: "psi")
  local a, fa, b, r, j, furtherargs, e, n;
  name psi::expand;
begin
  assert(nops(ps) = 1 or nops(ps) = 2);
  e:= op(ps, 1);
  if nops(ps) = 2 then
    n:= op(ps, 2)
  else
    n:= 0
  end_if;

  furtherargs:= args(2..args(0));
  
  // recursively expand the argument
  e := expand(e, furtherargs);

  
  if domtype(e) = DOM_INT then // rule 0
    if e > 0 then
      return(psi(1, n) + (-1)^n*fact(n)*_plus(j^(-n-1) $ j = 1 .. (e - 1)))
    else // should not happen, since already done in SPECFUNC/psi.mu
      error("singularity")
    end_if
  end_if;

  r := 0;
  if type(e) = "_plus" or testtype(e, Type::Numeric) then // rule 1
    if type(e) = "_plus" then
      a := select(e, testtype, Type::Numeric);
    else
      a := e;
    end_if;
    fa := floor(Re(a));
    e := e - fa;
    if fa >= 0 then
      r :=  (-1)^n*fact(n)*_plus((e + j)^(-n-1) $ j = 0 .. (fa - 1))
    else // fa < 0
      r := -(-1)^n*fact(n)*_plus((e + j)^(-n-1) $ j = fa .. -1)
    end_if;
  end_if;

  if type(e) = "_mult" or domtype(e/I) = DOM_INT then // rule 2
    if type(e) = "_mult" then
      b := select(e, testtype, Type::Numeric)
    else
      b := e
    end_if;
    if domtype(b/I) = DOM_INT then
      b := b/I
    elif domtype(b) <> DOM_INT then
      b := 1
    end_if;
    e := e/b;
    if b > 0 then /* r + psi(b*e, n) */
      r + if n = 0 then ln(b) else null() end_if
      + b^(-n-1)*_plus(psi(e + j/b, n) $ j = 0 .. (b - 1))
    else // b < 0, rule 3
      r + fact(n)*(-b)^(-n-1)*e^(-n-1)
      + expand((-1)^n*PI^(n+1) * D([1 $ n], cot), furtherargs)(-b*e*PI)
          + (-1)^n * /* psi(-b*e, n) */
      (if n = 0 then ln(-b) else null() end_if
       + (-b)^(-n-1)*_plus(psi(e - j/b, n) $ j = 0 .. (-b - 1)))
      end_if;
   else
     r + psi(e, n)
   end_if
end_proc, () -> [property::depends(args()), DIGITS]):

