/*--
	sin/expand -- the function attribut "expand" for sin

 sin(-x)     = -sin(x)                                                 
 sin(x +- y) = sin(x) * cos(y) +- sin(y) * cos(x)                      
               n/2                                                     
               ---                                                     
               \   (   n  )                                            
 sin(n * x)  = /   ( 2*i+1) cos(x)^(n-2*i-1)*sin(x)^(2*i+1)*(-1)^(i+1) 
               ---                                                     
               i=0  
--*/

sin::expand:= prog::remember(
proc(a)
  local n, t, y, i;
  name sin::expand;
begin
   if type(a) <> "sin" then
      return(expand(a));
   end_if;
   // a = sin(y)
   y:= op(a, 1);
   if not has([args()], "NoRecursiveExpand") then
     y := expand(y, args(2..args(0)));
   end_if;
   case type(y)
     of "_plus" do
       n := _plus(op(y, i) $ i = 1 .. nops(y) div 2);
       y := _plus(op(y, i) $ i = (nops(y) div 2) + 1 .. nops(y));
       return(expand(sin::expand(sin(n), "NoRecursiveExpand")*cos::expand(cos(y), "NoRecursiveExpand")
                    +cos::expand(cos(n), "NoRecursiveExpand")*sin::expand(sin(y), "NoRecursiveExpand"),
                    ArithmeticOnly, args(2..args(0))))
     of "_mult" do
       n := op(y, nops(y));
       t := type(n);
       // first apply sin(I*x) = I*sinh(x)
       if t = DOM_COMPLEX and iszero(op(n, 1)) then
         return(I* expand(sinh(y/I), args(2..args(0))))
       end_if;
       // sin(n*x) = sin(x)^(..)*cos(x)^(..) + ...
       // Do this, if n is integer and x contains at least on symbol,
       // because we do not want to expand sin(5*sqrt(2)) etc.
       if indets(y) minus Type::ConstantIdents = {} then
         break;
       end_if:
       if t = DOM_INT or t = DOM_RAT then
          if n < 0 then
             return(expand(-sin(-y), args(2..args(0))))
          else // n > 0
               // the following is due to Francois Maltey
             if n=1 then
               return(sin(y))
             end_if; // avoids loop in expand(sin(1))
             if t = DOM_INT then
               y := y / n;
               return(
                  subs(expand(((#C+I*#S)^n-(#C-I*#S)^n)/2/I, args(2..args(0))),
                       [#C=cos(y),#S=sin(y)])
                      )
             end_if;
          end_if;
       end_if;
   end_case;
   sin(y)
end_proc, () -> [property::depends(args()), DIGITS]):
