// tan::expand - the expand slot for tan

// applies
//
//  tan(x + y) -> (tan(x) + tan(y))/( 1 - tan(x) tan(y))
//  tan(I*x) -> I*tanh(x)

// does *not* apply tan(x) -> sin(x)/cos(x)

tan::expand:= prog::remember(
proc(a: "tan")
  local n, t, y, S, even, odd, dummy, summands, u, i;
  name tan::expand;
begin
  y:= expand(op(a, 1), args(2..args(0)));
  
  case type(y)
    of "_plus" do
      // we have to expand tan(x1 + ... + xn)
      // this equals numerator/denominator,
      // where numerator consists of all summands of the
      // form n(k) * tan(xi_1)* ...*tan(xik)
      // where n(k) = 0 if k is even, Sign(4*k+1)=1, Sign(4*k-1)=-1
      // {x_1, ..., x_ik} runs through all subsets of {x1, ..., xn}
      // and where denominator consists of all summmands of the form
      // d(k) * tan(xi_1)* ...*tan(xik)
      // where d(k) = 0 if k is odd, d(k)= 1 if k mod 4 = 0, and
      // d(k)=-1 if k mod 4 = 2. (this includes the case k=0)
      // we start by computing the powerset
      summands:= [op(y)];
      // we have to exclude poles of the tan: this is just done
      // "syntactically" at the moment
      // use "even" as a dummy, split into poles and non-poles
      [t, summands, even]:= split(summands, x-> type((x/PI) - 1/2) =DOM_INT);
      // the kernel should not allow more than one summands
      // of the kind (n+1/2)*PI 
      assert(nops(t) <= 1);
      S:= combinat::powerset({op(map(summands, u->expand(tan(u), args(2..args(0)))))});
      [even, odd, dummy] := split(S, set -> nops(set) mod 2 = 0);
      even:= map(even, set ->
                 if nops(set) mod 4 = 0 then
                   _mult(op(set))
                 else  
                   -_mult(op(set))
                 end_if
                   );
      odd:= map(odd, set->
                if nops(set) mod 4 = 1 then
                  _mult(op(set))
                else
                  -_mult(op(set))
                end_if
                );
      if nops(t) mod 2 = 0 then
        return(_plus(op(odd))/ _plus(op(even)))
      else
        return(-_plus(op(even))/_plus(op(odd)))
      end_if;
     of "_mult" do 
      n := op(y, nops(y));
      t := domtype(n);
      // first apply tan(I*x) = I*tanh(x)
      if t = DOM_COMPLEX and iszero(op(n, 1)) then
        return(I* expand(tanh(y/I), args(2..args(0))))
      end_if;

       // because we do not want to expand tan(5*sqrt(2)) etc.
      if indets(y, All) minus Type::ConstantIdents minus
        {hold(_plus), hold(_power), hold(_mult)}= {} then
        break;
      end_if;
      
      if t = DOM_INT then
        if n < 0 then
          return(expand(-tan(-y), args(2..args(0))))
        else // n > 0
          u:= tan(y/n);
          S:= u;
          for i from 2 to n do
            // we have S = tan((i-1)*y/n) and u = tan(y/n)
            // compute S:= tan(i*y/n) by using the addition formula
            // We must *not* use normal directly because this would
            // produce too many hastype - calls 
            S:= _divide(op(stdlib::normal(- (u+S)/ (u*S-1))))
          end_for;
          return(S)         
        end_if;
      end_if;
  end_case;
  tan(y)  
end_proc, () -> [property::depends(args()), DIGITS]):
