
tanh::expand:= prog::remember(
proc(a: "tanh")
  local y, n, t, i: DOM_INT, u, S;
  name tanh::expand;
begin
  y:= expand(op(a, 1), args(2..args(0)));

  case type(y)
    of "_plus" do
      // tanh(x1 + x2 + ...) = -I*tan(I*(x1 + x2 + ...)) 
      return(normal(-I* tan::expand(hold(tan)(y*I), args(2..args(0)))))
    of "_mult" do
      n := op(y, nops(y));
      t := domtype(n);
      // first apply -I*tan(-x) = tanh(I*x)
      if t = DOM_COMPLEX and iszero(op(n, 1)) then
        return(-I* expand(tan(-y/I), args(2..args(0))))
      end_if;

      if indets(y, All) minus Type::ConstantIdents minus
        {hold(_plus), hold(_power), hold(_mult)}= {} then
        break;
      end_if;
      
      if t = DOM_INT then
        if n < 0 then
          return(expand(-tanh(-y), args(2..args(0))))
        else // n>0
          // this is similar to tan
          u:= tanh(y/n);
          S:= u;
          for i from 2 to n do
            // we have S = tanh((i-1)*y/n) and u = tanh(y/n)
            // compute S:= tanh(i*y/n) by using the addition formula
            // We must *not* use normal directly because this would
            // produce too many hastype - calls 
            S:= _divide(op(stdlib::normal((u+S)/ (u*S+ 1))))
          end_for;
          return(S)  
        end_if
      end_if
  end_case;
  tanh(y)
end_proc, () -> [property::depends(args()), DIGITS]):
