alias(BesselJ=besselJ::float):
alias(BesselI=besselI::float):
alias(realJI=specfunc::Bessel::realJI):
alias(complexJI=specfunc::Bessel::complexJI):
alias(asymptK=specfunc::Bessel::asymptK):
alias(signc=specfunc::Bessel::signc):
alias(fln=specfunc::Bessel::fln):
alias(sabs=specfunc::abs):
alias(ssqrt=specfunc::sqrt):
alias(ssinh=specfunc::sinh):
alias(scosh=specfunc::cosh):
alias(sgamma=specfunc::gamma):
alias(strunc=specfunc::trunc):
alias(sround=specfunc::round):
alias(sfrac=specfunc::frac):
alias(ln10=0.4342944819):

BesselI := proc(vv,xx)
    local v, x;
    save z;
    begin
    v := float(vv):
    x := float(xx):

    if not((type(v)=DOM_FLOAT or type(v)=DOM_COMPLEX) and
           (type(x)=DOM_FLOAT or type(x)=DOM_COMPLEX)) then

	return(besselI(v,x)):
    end_if:

    if iszero(v) and iszero(x) then 
        return(float(1))
    end_if:

    if type(v)=DOM_FLOAT and iszero(sfrac(v)) then
	v := strunc(v):
	if not iszero(x) and iszero(Re(x)) then
	    return(float(I^(-v)*BesselJ(v,-Im(x)))):
	end_if:
    end_if:

    if type(v)=DOM_INT and (v<0) then
	float(BesselI(-v,x)):

      elif iszero(x) then
	if iszero(v) then
	    float(1):
	  elif Re(v) > 0 then
	    float(0):
	  else
	    error("singularity"):
	end_if:

      elif iszero(v-1/2) then
        float(ssqrt(float(2)/PI)*ssinh(x)/ssqrt(x)):
      elif iszero(v+1/2) then
        float(ssqrt(float(2)/PI)*scosh(x)/ssqrt(x)):

      elif (signc(float(v)) = 1 or sabs(Im(v)) > 1) and
	    2*sround(ln10*fln(sabs(x)))-sround(ln10*fln(sabs(v))) < -DIGITS then
	// truncated series at 0: but this can't be used if there is a chance 
	// that v+k ~ 0 for some integer k                                    
	float((x/2)^v/sgamma(v+1)*(1+x^2/4/(v+1))):
      elif type(x)=DOM_FLOAT and (type(v)=DOM_FLOAT or type(v)=DOM_INT) then
	float(realJI(v,x,1,FALSE)):

      else
	float(complexJI(v,x,1,FALSE)):
    end_if:
end_proc:

BesselI:= prog::remember(BesselI, () -> [property::depends(args()), DIGITS]):

unalias(ln10):
unalias(sabs):
unalias(ssqrt):
unalias(ssinh):
unalias(scosh):
unalias(sgamma):
unalias(strunc):
unalias(sround):
unalias(sfrac):


