alias(BesselY=besselY::float):
alias(realYK=specfunc::Bessel::realYK):
alias(complexYK=specfunc::Bessel::complexYK):
alias(ssqrt=specfunc::sqrt):
alias(ssin=specfunc::sin):
alias(scos=specfunc::cos):
alias(sexp=specfunc::exp):
alias(strunc=specfunc::trunc):
alias(sround=specfunc::round):
alias(sfrac=specfunc::frac):
alias(sabs=specfunc::abs):

BesselY := proc(vv,xx)
    local v, x;
    save z;
    begin

    v := float(vv):
    x := float(xx):
    if not((type(v)=DOM_FLOAT or type(v)=DOM_COMPLEX) and
           (type(x)=DOM_FLOAT or type(x)=DOM_COMPLEX)) then
	return(besselY(v,x)):

      elif iszero(x) then
	error("singularity"):
    end_if:
    if type(v)=DOM_FLOAT and iszero(sfrac(v)) then
	v := strunc(v):
    end_if:

    if type(v)=DOM_INT and (v<0) then
	float((-1)^v *BesselY(-v,x)):

      elif iszero(v-1/2) then
        -float(ssqrt(float(2)/PI)*scos(x)/ssqrt(x)):

      elif iszero(v+1/2) then
        float(ssqrt(float(2)/PI)*ssin(x)/ssqrt(x)):

      //elif type(v)=DOM_FLOAT and
             //float(sabs(sround(2*v)-2*v)) < float(10^(-DIGITS)) then 
        //delete z;
        //float(eval(subs(besselY(round(2*v)/2,z),z=x)));

      //elif type(x)=DOM_FLOAT and (x>0) then
      elif type(x)=DOM_FLOAT and (type(v)=DOM_FLOAT or type(v)=DOM_INT) then
	float(realYK(v,x,1)):
      else
	float(complexYK(v,x,1,FALSE)):
    end_if:
end_proc:

BesselY:= prog::remember(BesselY, () -> [property::depends(args()), DIGITS]):

unalias(ssqrt):
unalias(ssin):
unalias(scos):
unalias(sexp):
unalias(strunc):
unalias(sfrac):
