//
//
//      meijerg -- Numerical Meijer G Function
//
//

alias(hypergeom=hypergeom::float):
alias(fmeijerG=meijerG::float):

alias(Hypergeom=specfunc::Hypergeom):
alias(MeijerG=specfunc::MeijerG):

alias(typenumcomplex=Hypergeom::typenumcomplex):
alias(CondC=Hypergeom::CondC):
alias(CondA=Hypergeom::CondA):

alias(evalfp=MeijerG::evalp):
alias(forall=MeijerG::forall):
alias(epsilon=MeijerG::epsilon):
alias(flip=MeijerG::flip):
alias(slater=MeijerG::slater):
alias(Inf=MeijerG::Inf):

evalfp:=proc(z)
begin
  bool(z=0 or typenumcomplex(z)):
end_proc:

  // Test if all zs are zero or type complex(float)
forall:=proc(zs)
  local z,answer;
begin
  answer:=TRUE:
for z in zs do
    if not(evalfp(z)) then
      answer:=FALSE:
      break:
    end_if:
  end_for:
return(answer):
end_proc:

fmeijerG:=proc(As,Bs,z)
  local as,bs,cs,ds,as1,bs1,cs1,ds1,z1,m,n,p,q,delta,t,sigma,i,answer;
  begin

  if args(0) = 5 then
    [As, Bs, z]:= meijerG::checkParameters(args());
    if As = FAIL then
       return(hold(meijerG)(op(float(Bs))));
    end_if:
  elif args(0) < 3 or
       args(0) > 5 then
         error("expecting 3 or 5 arguments in meijerG");
  end_if;
  if has([args()], "go") then
     // the parameters were processed by the interface
     // function meijerG that called meijerG::float.
     // There is no need to call meijerG again to
     // normalize and simplify the parameter lists
  else
     // Simplify and normalize the parameter lists
     // by calling the interface function meijerG.
     // It will call meijerG::float with the additional
     // flag "go".
     return(meijerG(float(As), float(Bs), float(z)))
  end_if:

  [as,bs] := As;
  [cs,ds] := Bs;
  as1:=float(as):
  bs1:=float(bs):
  cs1:=float(cs):
  ds1:=float(ds):
  z1:=float(z):
  if type(as1)=DOM_LIST and type(bs1)=DOM_LIST and type(cs1)=DOM_LIST and
      type(ds1)=DOM_LIST and forall([op(as1),op(bs1),op(cs1),op(ds1),z1]) then
    m:=nops(as1):
    n:=nops(bs1):
    p:=nops(cs1):
    q:=nops(ds1):
    delta:=m+n-p-q:
    if delta < 0 then
      answer:=Inf(as1,bs1,cs1,ds1,z1):
    elif delta > 0 then
      answer:=flip(as1,bs1,cs1,ds1,z1):
    else
      t:=abs(/*Re*/(z1)):
      if t<1 then
	answer:=Inf(as1,bs1,cs1,ds1,z1):
      elif t>1 then
	answer:=flip(as1,bs1,cs1,ds1,z1):
      else
	sigma:=_plus(Re(as1[i])$i=1..m)+_plus(Re(bs1[i])$i=1..n)
              -_plus(Re(cs1[i])$i=1..p)-_plus(Re(ds1[i])$i=1..q):
	if sigma>1 then
	  answer:=Inf(as1,bs1,cs1,ds1,z1):
	else
          // print("Unable to compute meijerG"):
	  return(hold(meijerG)([as1,bs1],[cs1,ds1],z1));
	end_if:
      end_if:
    end_if:
  else
    answer:=hold(meijerG)([as1,bs1],[cs1,ds1],z1):
  end_if:
  if answer=FAIL then
    answer:=hold(meijerG)([as1,bs1],[cs1,ds1],z1):
  end_if;
  return(answer):
end_proc:

fmeijerG:= prog::remember(fmeijerG, () -> [property::depends(args()), DIGITS]):

// Evaluate MeijerG using L=L_infinity contour.
Inf:=proc(as,bs,cs,ds,z)
  local oldDIGITS,m,n,p,q,as1,bs1,cs1,ds1,e,a,i,j,answer,tol, flipped;
  save DIGITS;
  begin
  if args(0) = 6 then
     flipped:= "flipped"
  else
     flipped:= null();
  end_if:
  tol:=float(10^(-DIGITS)):
  oldDIGITS:=DIGITS:
  DIGITS:=DIGITS+3:
  m:=nops(as):
  n:=nops(bs):
  p:=nops(cs):
  q:=nops(ds):
  as1:=float(as):
  bs1:=float(bs):
  cs1:=float(cs):
  ds1:=float(ds):
  if CondC([op(cs1)],p) and 
     CondA([op(as1)],[op(ds1)],m,q) and 
     CondA([op(ds1)],[op(cs1)],q,p) and 
     CondA([op(cs1)],[op(bs1)],p,n) then
  	answer:=slater(as1,bs1,cs1,ds1,z, flipped):
  else
    // Although I hate traperrors (tcs), in case the previous conditions
    // happened to miss: just in case it might work, try it:
    if traperror((answer := slater(as1,bs1,cs1,ds1,z,flipped))) = 0 and answer<>FAIL then
      return(answer);
    end_if:
    e:=epsilon(as1,bs1,cs1,ds1):
    answer:=0:
    DIGITS:=(p+1)*oldDIGITS:
    for j from 0 to 5 do
      DIGITS:=DIGITS+10:
      e:=e/100:
      as1:=[(as[i]+(i-1)*e)$i=1..m]:
      bs1:=[(bs[i]+(m+i-1)*e)$i=1..n]:
      cs1:=[(cs[i]+(m+n+i-1)*e)$i=1..p]:
      ds1:=[(ds[i]+(m+n+p+i-1)*e)$i=1..q]:
      if traperror((a:=slater(as1,bs1,cs1,ds1,z,flipped)))<>0 or
         a = FAIL then
        return(FAIL);
      end_if;
      a:=float(a):
      if a = RD_NAN then 
         return(a);
      end_if:
      if abs(a-answer) < 10*tol then
        break:
      end_if:
      answer:=a:
    end_for:
  end_if:
  return(answer):
end_proc:

// Starting epsilon.
epsilon:=proc(as,bs,cs,ds)
  local xs;
  begin
  //xs:=subs([op(as),op(bs),op(cs),op(ds)],0=null()):
  xs:=[op(as),op(bs),op(cs),op(ds)]:
  xs:=min(op(map(xs,abs))):
  if not(iszero(xs)) then
	xs*float(10^(-DIGITS)):
  else
	float(10^(-DIGITS)):
  end_if:
end_proc:

slater:=proc(as,bs,cs,ds,z)
  local m,n,p,q,ci,cstar,prod1,prod2,prod3,prod4,prod,lt1,lt2,f,i,j,answer;
  begin
  m:=nops(as):
  n:=nops(bs):
  p:=nops(cs):
  q:=nops(ds):
  answer:=0:
  for i from 1 to p do
    ci:=cs[i]:
    cstar:=subsop(cs,i=null()):
    prod1:=_mult((gamma(1-as[j]+ci))$j=1..m):
    prod3:=_mult((gamma(cstar[j]-ci))$j=1..p-1):
    if traperror((
        prod2:=_mult((gamma(bs[j]-ci))$j=1..n):
        prod4:=_mult((gamma(1-ds[j]+ci))$j=1..q):
      )) <> 0 then
      // We hit a singularity of gamma. The numerator 
      // prod1*prod3 of the following prod is finite, 
      // the denominator prod2*prod4 is infinity.
      // Thus, prod = 0. This term of the sum computed 
      // by 'for i from 1 to p' is 0, so just skip this 
      // term and proceed to the next value of i:
      next;
    end_if:
    prod:=(prod1*prod3)/(prod2*prod4):
    lt1:=[(1-as[j]+ci)$j=1..m,(1-bs[j]+ci)$j=1..n]:
    lt2:=[(1-cstar[j]+ci)$j=1..p-1,(1-ds[j]+ci)$j=1..q]:
    if traperror((f:=float(hypergeom(lt1,lt2,(-1)^(n-p)*z))))<>0 then
      return(FAIL);
    end_if;
    // Note that (1/z)^(-ci) <> z^ci, if z < 0. 
    // The following form of the factor z^ci seems to be correct:
    if args(0) = 6 then
       answer:=answer+float(prod/(1/z)^ci*f):
    else
       answer:=answer+float(prod*z^ci*f):
    end_if:
  end_for:
  return(answer):
end_proc:

// Change contour from L[infinity] to L[-infinity].
flip:=proc(as,bs,cs,ds,z)
  local m,n,p,q,as1,bs1,cs1,ds1,z1,i,answer;
begin
  m:=nops(as):
  n:=nops(bs):
  p:=nops(cs):
  q:=nops(ds):
  as1:=[(1-cs[i])$i=1..p]:
  bs1:=[(1-ds[i])$i=1..q]:
  cs1:=[(1-as[i])$i=1..m]:
  ds1:=[(1-bs[i])$i=1..n]:
  z1:=1/z:
  answer:=Inf(as1,bs1,cs1,ds1,z1, "flipped"):
  return(answer):
end_proc:

unalias(hypergeom):
unalias(Hypergeom):
unalias(MeijerG):
unalias(fmeijerG):
unalias(typenumcomplex):
unalias(CondC):
unalias(CondA):

unalias(evalfp):
unalias(forall):
unalias(epsilon):
unalias(flip):
unalias(slate):
unalias(Inf):

