
/*--
	log/Im -- the function attribut "Im" for log
--*/

log := slot( log, "Im", proc(b, x)
    local s;
begin 
    s:= sign(x);
    if s = 1 then 
        return( 0 )
    elif s = -1 then 
        return( PI/ln(b) )
    elif iszero(s) then 
        error("singularity")
    elif domtype(x) = DOM_COMPLEX then
        if op(x,1) = 0 then
            return( 1/2*PI*sign(op(x,2))/ln(b) )
        else
            return( arg(op(x,1),op(x,2))/ln(b) )
        end_if
    elif not has(s,hold(sign)) then
        return( arg(Re(s),Im(s))/ln(b) )
    else
        return( FAIL )
    end_if
 end_proc  ):

// end of file 
