/*--
	rectform::_mult  --  multiply elements of domain rectform
--*/

rectform::_mult :=
proc(x,y)
    local i, L;
begin
    if args(0) = 1 or (args(0) = 2 and y = 1) then return(rectform::new(x)); end_if;
    L := [args()];
    while nops(L) > 2 do
      L := [L[i] * L[i+1] $ i = 1..nops(L)-1 step 2,
            if nops(L) mod 2 = 1 then L[-1] end_if];
    end_while;
    [x, y] := L;

    if domtype(x) = DOM_POLY then x:= expr(x) end_if;
    if domtype(y) = DOM_POLY then y:= expr(y) end_if;

    if domtype(x) <> rectform then x := rectform::new(x) end_if;
    if domtype(y) <> rectform then y := rectform::new(y) end_if;

    new(rectform,
        extop(x,1)*extop(y,1)-extop(x,2)*extop(y,2), // Re(x*y) 
        extop(x,1)*extop(y,2)+extop(x,2)*extop(y,1), // Im(x*y) 
        extop(x,1)*extop(y,3)+extop(x,3)*extop(y,1)+
            extop(x,3)*extop(y,3)+I*(extop(x,2)*extop(y,3)+
            extop(x,3)*extop(y,2))
    )
end_proc:

// end of file 
