/*--
	rectform::_power  --  the function _power for rectform
--*/

rectform::_power:=
proc(a,b)
  name rectform::_power;
  local t, ai, bi, arga, absa;
begin

  arga:= arg(expr(a));
  absa:= abs(expr(a));

  if iszero(absa) then
    // this is only defined for nonnegative b, but we don't have
    // to check this here; in any case, it's real
    return(new(rectform, 0^expr(b), 0, 0))
  end_if;
  
  if domtype(a) <> rectform then
    a := rectform::new(a)
  end_if;
  if domtype(b) <> rectform then
    b := rectform::new(b)
  end_if;

  if extop(a,3) <> 0 or extop(b,3) <> 0 then
    return(new( rectform,0,0,_power(rectform::expr(a),rectform::expr(b)) ))
  end_if;
  ai := extop(a,2); a := extop(a,1);
  bi := extop(b,2); b := extop(b,1);
  t := b+I*bi;
  if domtype((a+I*ai)^t) = DOM_COMPLEX then
    return( rectform::new((a+I*ai)^t) )
  elif domtype(t) = DOM_INT then
    if iszero(t) then 
      return( new(rectform, 1, 0, 0) )
    elif iszero(ai) then
      return( new(rectform,a^b,0,0) )
    elif iszero(a) then
      // (ai * I)^2 = -ai^2
      // therefore, if t = 2*k, then (ai * I)^t = (-1)^k *ai^(2*k) = (-1)^(t/2) * ai^t
      //            if t = tt+1 where tt is even, then (ai*I)^t = (-1)^(tt/2) * ai^tt * ai*I = I*(ai^t *(-1)^((t-1)/2) )
      if t mod 2 = 0 then
        return( new(rectform, (-1)^(t/2) * ai^t, 0, 0) )
      else
        return( new(rectform, 0, ai^t * (-1)^((t-1)/2), 0))
      end_if
    elif b = 1 then
      return( new(rectform,a,ai,0) )
    elif b = -1 then
      t := a^2+ai^2;
      return( new(rectform,a/t,-ai/t,0) )
    elif b < -1 then
      t := rectform::new(expand((a+I*ai)^(-b)));
      a := extop(t,1); ai := extop(t,2);
      t := a^2+ai^2;
      return( new(rectform,a/t,-ai/t,0) )
    else
      assert(b>0);
      t:= expand((`#X` + I*`#Y`)^b);
      // we split this in real and imaginary part
      t:= subs(split(t, has, I), I=1);
      t:= subs(t, `#X` = a, `#Y` = ai);
      return(new(rectform, op(t,2), op(t, 1), 0))
    end_if
  elif domtype(t) = DOM_RAT then
    if t = 1/2 then
      case is(ai = 0)
        of TRUE do
          if sign(a) = -1 then
            return(new(rectform, 0, (-a)^(1/2), 0))
          elif sign(a) = 1 then
            return(new(rectform, a^(1/2), 0, 0))
          end_if;  
          t:= absa^(1/2);
          return( new(rectform, 1/2*t*(1+sign(a)), 1/2*t*(1-sign(a)), 0) )
        of FALSE do
          t := sqrt(a^2 + ai^2)/2;
          return(new(rectform, sqrt(a/2 + t), sign(ai)*sqrt(t - a/2), 0))   
      end_case;
      // ai may be nonzero, but we do not know
      t:= absa^(1/2);
      return(new(rectform, t*cos(arga/2), t*sin(arga/2), 0))
    elif is(ai = 0) = TRUE then
      t := abs(a)^b;
      ai := (1/2*abs(b)-1/2*abs(b)*sign(a))*PI;
      return( new(rectform, t*cos(ai), t*sin(ai)*sign(b), 0) )
    elif is(a =0) = TRUE then
      t := abs(ai)^b;
      ai := 1/2*sign(ai)*abs(b)*PI;
      return( new(rectform, t*cos(ai), t*sin(ai)*sign(b), 0) )
    else
      t := absa^b;
      ai := abs(b)*arg(a,ai);
      return( new(rectform,t*cos(ai),t*sin(ai)*sign(b),0) )
    end_if
    // t is not integer or rational
  elif iszero(bi) and iszero(ai) and is(a>0, Goal = TRUE) then
    return( new(rectform, a^b, 0, 0))
  else 
    return( slot(exp,"rectform")(t*ln(a+I*ai)) )
  end_if
end_proc:

// end of file 
