/*--
  arccosh/rectform -- the function attribut "rectform" for arccosh
--*/

arccosh::rectform := proc(xx)
   local a, b, x;
begin
 x:= rectform::new(xx);

 if extop(x,3) <> 0 then
     return(new(rectform,0,0,hold(arccosh)(rectform::expr(x))));
 else
     a:= extop(x,1);
     b:= extop(x,2);
     if domtype(a+I*b) = DOM_COMPLEX
        and (domtype(a) = DOM_FLOAT or domtype(b) = DOM_FLOAT)
     then
         return(rectform::new(arccosh(a+I*b)));
     else
         if iszero(b) then
            if is(a >= 1) = TRUE then
               return(new(rectform, arccosh(a), 0, 0));
            end_if;
            if is(a <= -1) = TRUE then
               return(new(rectform, ln(abs(x + sqrt(x^2 - 1))), PI, 0));
            end_if;
         end_if;
     end_if;
     x:= a + I*b;
     return(new(rectform, ln(abs(x + sqrt(x^2 - 1))), arg(x + sqrt(x^2 - 1)), 0));
 end_if
end_proc:
