//    

/*--
	arctan/rectform -- the function attribut "rectform" for arctan
--*/

arctan::rectform:=
proc(xx, yy)
  local a, b, s, x, y;
begin
  case args(0)
    of 1 do
      x:= rectform::new( xx );
      break
    of 2 do
      // arctan(x,y)
      x:= rectform::new( xx );
      y:= rectform::new( yy );
  end_case;
	    
  if args(0) = 2 then
    if extop(x,3) <> 0 or extop(y,3) <> 0 then
      new(rectform,0,0,hold(arg)(rectform::expr(x),rectform::expr(y)))
    else
      /* assume that arctan has been correctly called, with two real
         arguments */
      new( rectform,hold(arg)(xx,yy),0,0 )
    end_if
  elif extop(x,3) <> 0 then
    new( rectform,0,0,hold(arctan)(rectform::expr(x)) )
  else
    a:= extop(x,1);
    b:= extop(x,2);
    if domtype(a+I*b) = DOM_COMPLEX
      and (domtype(a) = DOM_FLOAT or domtype(b) = DOM_FLOAT)
      then
      rectform::new(arctan(a+I*b))
    elif iszero(b) then
      new( rectform,arctan(a),0,0 )
    elif iszero(a) and iszero(abs(b)-1) then
      error("singularity")
    else
      s:= (a^2+(b+1)^2)/(a^2+(b-1)^2);
      new(rectform, 1/2*arg(1-b, a)-1/2*arg(1+b, -a), 1/4*ln(s), 0)
    end_if
  end_if
end_proc:
 
// end of file 
