//    

/*--
	ln::rectform -- the function attribut "rectform" for ln
--*/

ln::rectform:= 
proc(xx)
        local a, b, t, x, argab;
    begin
        x:= rectform::new(xx);

        if extop(x,3) <> 0 then
            return( new(rectform, 0, 0, hold(ln)(rectform::expr(x))) )
        elif type(xx) = "abs" then
            return( new(rectform, ln(x), 0, 0) )
        else
            a:= extop(x,1);
            b:= extop(x,2);
            if domtype(a+I*b) = DOM_COMPLEX
            and (domtype(a) = DOM_FLOAT or domtype(b) = DOM_FLOAT)
            then
                return( rectform::new(ln(a+I*b)) )
            elif iszero(a+I*b) then
                error("singularity")
            elif iszero(b) then 
                return( new(rectform, ln(abs(a)), (1/2-1/2*sign(a))*PI, 0) )
            else
                t:= a^2+b^2;
                if iszero(a) then
                    argab:= 1/2*sign(b)*PI
                else
                    argab:= arg(a, b);
                    /*
                    if has(argab, I) then
                     // prefer different form
                      argab:= arctan(b/a) + PI/2 * sign(b) * (1 - sign(a))
                    end_if
                    */
                end_if;    
                if testtype( sqrt(t),Type::Numeric ) then
                    return( new(rectform, ln(sqrt(t)), argab, 0) )
                else
                    return( new(rectform, 1/2*ln(t), argab, 0) )
                end_if
            end_if
        end_if
    end_proc:

// end of file 
